/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;

public abstract class GmsImpl {
    protected final GMS gms;
    protected final Merger merger;
    protected final Log log;
    volatile boolean leaving = false;

    protected GmsImpl(GMS gms) {
        this.gms = gms;
        this.merger = gms.merger;
        this.log = gms.getLog();
    }

    public abstract void join(Address var1, boolean var2);

    public abstract void joinWithStateTransfer(Address var1, boolean var2);

    public abstract void leave(Address var1);

    public void handleJoinResponse(JoinRsp join_rsp) {
    }

    public void handleLeaveResponse() {
    }

    public void suspect(Address mbr) {
    }

    public void unsuspect(Address mbr) {
    }

    public void merge(Map<Address, View> views) {
    }

    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
    }

    public void handleMergeResponse(MergeData data, MergeId merge_id) {
    }

    public void handleMergeView(MergeData data, MergeId merge_id) {
    }

    public void handleMergeCancelled(MergeId merge_id) {
    }

    public void handleDigestResponse(Address sender, Digest digest) {
    }

    public void handleMembershipChange(Collection<Request> requests) {
    }

    public void handleViewChange(View new_view, Digest digest) {
    }

    public void init() throws Exception {
        this.leaving = false;
    }

    public void start() throws Exception {
        this.leaving = false;
    }

    public void stop() {
        this.leaving = true;
    }

    protected void sendMergeRejectedResponse(Address sender, MergeId merge_id) {
        Message msg = new Message(sender).setFlag(Message.Flag.OOB);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getId(), hdr);
        this.log.debug("%s: merge response=%s", this.gms.local_addr, hdr);
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }

    protected void wrongMethod(String method_name) {
        this.log.warn("%s: %s() should not be invoked on an instance of %s", this.gms.local_addr, method_name, this.getClass().getName());
    }

    public static class Request {
        static final int JOIN = 1;
        static final int LEAVE = 2;
        static final int SUSPECT = 3;
        static final int MERGE = 4;
        static final int JOIN_WITH_STATE_TRANSFER = 6;
        int type = -1;
        Address mbr;
        boolean suspected;
        Map<Address, View> views;
        boolean useFlushIfPresent;

        Request(int type, Address mbr, boolean suspected) {
            this.type = type;
            this.mbr = mbr;
            this.suspected = suspected;
        }

        Request(int type, Address mbr, boolean suspected, Map<Address, View> views, boolean useFlushPresent) {
            this(type, mbr, suspected);
            this.views = views;
            this.useFlushIfPresent = useFlushPresent;
        }

        Request(int type, Address mbr, boolean suspected, Map<Address, View> views) {
            this(type, mbr, suspected, views, true);
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "JOIN(" + this.mbr + ")";
                }
                case 6: {
                    return "JOIN_WITH_STATE_TRANSFER(" + this.mbr + ")";
                }
                case 2: {
                    return "LEAVE(" + this.mbr + ", " + this.suspected + ")";
                }
                case 3: {
                    return "SUSPECT(" + this.mbr + ")";
                }
                case 4: {
                    return "MERGE(" + this.views.size() + " views)";
                }
            }
            return "<invalid (type=" + this.type + ")";
        }

        public boolean canBeProcessedTogether(Request other) {
            if (other == null) {
                return false;
            }
            int other_type = other.type;
            return !(this.type != 1 && this.type != 2 && this.type != 3 || other_type != 1 && other_type != 2 && other_type != 3);
        }
    }
}

