/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.AsciiString;

public class TpHeader
extends Header {
    protected byte[] cluster_name;

    public TpHeader() {
    }

    public TpHeader(String n) {
        int len = n.length();
        this.cluster_name = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.cluster_name[i] = (byte)n.charAt(i);
        }
    }

    public TpHeader(AsciiString n) {
        this.cluster_name = n != null ? n.chars() : null;
    }

    public TpHeader(byte[] n) {
        this.cluster_name = n;
    }

    @Override
    public Supplier<? extends Header> create() {
        return TpHeader::new;
    }

    @Override
    public short getMagicId() {
        return 60;
    }

    @Override
    public String toString() {
        return String.format("[cluster_name=%s]", new String(this.cluster_name));
    }

    @Override
    public int serializedSize() {
        return this.cluster_name != null ? 2 + this.cluster_name.length : 2;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        int length = this.cluster_name != null ? this.cluster_name.length : -1;
        out.writeShort(length);
        if (this.cluster_name != null) {
            out.write(this.cluster_name, 0, this.cluster_name.length);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        short len = in.readShort();
        if (len >= 0) {
            this.cluster_name = new byte[len];
            in.readFully(this.cluster_name, 0, this.cluster_name.length);
        }
    }
}

