/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common.server;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.ping.common.OpenshiftPing;
import org.jgroups.ping.common.server.Server;
import org.jgroups.stack.Protocol;

public abstract class AbstractServer
implements Server {
    protected final int port;
    protected final Map<String, JChannel> CHANNELS = new HashMap<String, JChannel>();

    protected AbstractServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JChannel getChannel(String clusterName) {
        if (clusterName != null) {
            Map<String, JChannel> map = this.CHANNELS;
            synchronized (map) {
                return this.CHANNELS.get(clusterName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChannel(JChannel channel) {
        String clusterName = this.getClusterName(channel);
        if (clusterName != null) {
            Map<String, JChannel> map = this.CHANNELS;
            synchronized (map) {
                this.CHANNELS.put(clusterName, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeChannel(JChannel channel) {
        String clusterName = this.getClusterName(channel);
        if (clusterName != null) {
            Map<String, JChannel> map = this.CHANNELS;
            synchronized (map) {
                this.CHANNELS.remove(clusterName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasChannels() {
        Map<String, JChannel> map = this.CHANNELS;
        synchronized (map) {
            return !this.CHANNELS.isEmpty();
        }
    }

    private String getClusterName(JChannel channel) {
        String clusterName;
        if (channel != null && (clusterName = channel.getClusterName()) == null) {
            try {
                Field field = JChannel.class.getDeclaredField("cluster_name");
                field.setAccessible(true);
                return (String)field.get(channel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected final void handlePingRequest(JChannel channel, InputStream stream) throws Exception {
        if (channel != null) {
            OpenshiftPing handler = (OpenshiftPing)channel.getProtocolStack().findProtocol((Class<? extends Protocol>)OpenshiftPing.class);
            handler.handlePingRequest(stream);
        }
    }
}

