/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.AsyncInvocationStage;
import org.infinispan.util.concurrent.CompletableFutures;

public class BasicAsyncInvocationStage
implements BasicInvocationStage {
    private final CompletableFuture<Object> future;

    public BasicAsyncInvocationStage(CompletionStage<?> future) {
        this.future = (CompletableFuture)future;
    }

    @Override
    public Object get() throws Throwable {
        try {
            return CompletableFutures.await(this.future);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.future;
    }

    @Override
    public InvocationStage toInvocationStage(InvocationContext newCtx, VisitableCommand newCommand) {
        return new AsyncInvocationStage(newCtx, newCommand, this.future);
    }
}

