/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

@MBean(description="Fragments messages larger than fragmentation size into smaller packets")
public class FRAG2
extends Protocol {
    @Property(description="The max number of bytes in a message. Larger messages will be fragmented")
    protected int frag_size = 60000;
    protected final ConcurrentMap<Address, ConcurrentMap<Long, FragEntry>> fragment_list = Util.createConcurrentMap(11);
    protected int curr_id = 1;
    protected final List<Address> members = new ArrayList<Address>(11);
    protected Address local_addr;
    @ManagedAttribute(description="Number of sent fragments")
    AtomicLong num_frags_sent = new AtomicLong(0L);
    @ManagedAttribute(description="Number of received fragments")
    AtomicLong num_frags_received = new AtomicLong(0L);

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public long getNumberOfSentFragments() {
        return this.num_frags_sent.get();
    }

    public long getNumberOfReceivedFragments() {
        return this.num_frags_received.get();
    }

    public int fragSize() {
        return this.frag_size;
    }

    public FRAG2 fragSize(int size) {
        this.frag_size = size;
        return this;
    }

    synchronized int getNextId() {
        return this.curr_id++;
    }

    @Override
    public void init() throws Exception {
        int max_bundle_size;
        super.init();
        int old_frag_size = this.frag_size;
        if (this.frag_size <= 0) {
            throw new Exception("frag_size=" + old_frag_size + ", new frag_size=" + this.frag_size + ": new frag_size is invalid");
        }
        TP transport = this.getTransport();
        if (transport != null && this.frag_size >= (max_bundle_size = transport.getMaxBundleSize())) {
            throw new IllegalArgumentException("frag_size (" + this.frag_size + ") has to be < TP.max_bundle_size (" + max_bundle_size + ")");
        }
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_frags_sent.set(0L);
        this.num_frags_received.set(0L);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        long size = msg.getLength();
        if (size > (long)this.frag_size) {
            this.fragment(msg);
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        FragHeader hdr = (FragHeader)msg.getHeader(this.id);
        if (hdr != null) {
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: assembled_msg is %s", this.local_addr, assembled_msg);
                }
                assembled_msg.setSrc(msg.getSrc());
                this.up_prot.up(assembled_msg);
            }
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            FragHeader hdr = (FragHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                batch.replace(msg, assembled_msg);
                continue;
            }
            batch.remove(msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleViewChange(View view) {
        List<Address> new_mbrs = view.getMembers();
        List<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
        }
    }

    @ManagedOperation(description="removes all fragments sent by mbr")
    public void clearFragmentsFor(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.fragment_list.remove(mbr);
        this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
    }

    @ManagedOperation(description="Removes all entries from the fragmentation table. Dangerous: this might remove fragments that are still needed to assemble an entire message")
    public void clearAllFragments() {
        this.fragment_list.clear();
    }

    protected void fragment(Message msg) {
        try {
            byte[] buffer = msg.getRawBuffer();
            List<Range> fragments = Util.computeFragOffsets(msg.getOffset(), msg.getLength(), this.frag_size);
            int num_frags = fragments.size();
            this.num_frags_sent.addAndGet(num_frags);
            if (this.log.isTraceEnabled()) {
                Address dest = msg.getDest();
                this.log.trace("%s: fragmenting message to %s (size=%d) into %d fragment(s) [frag_size=%d]", this.local_addr, dest != null ? dest : "<all>", msg.getLength(), num_frags, this.frag_size);
            }
            long frag_id = this.getNextId();
            for (int i = 0; i < num_frags; ++i) {
                Range r = fragments.get(i);
                Message frag_msg = msg.copy(false, i == 0);
                frag_msg.setBuffer(buffer, (int)r.low, (int)r.high);
                FragHeader hdr = new FragHeader(frag_id, i, num_frags);
                frag_msg.putHeader(this.id, hdr);
                this.down_prot.down(frag_msg);
            }
        }
        catch (Exception e) {
            this.log.error("%s: fragmentation failure: %s", this.local_addr, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message unfragment(Message msg, FragHeader hdr) {
        ConcurrentMap tmp;
        Address sender = msg.getSrc();
        Message assembled_msg = null;
        ConcurrentMap<Long, FragEntry> frag_table = (ConcurrentMap<Long, FragEntry>)this.fragment_list.get(sender);
        if (frag_table == null && (tmp = this.fragment_list.putIfAbsent(sender, frag_table = Util.createConcurrentMap(16, 0.075f, 16))) != null) {
            frag_table = tmp;
        }
        this.num_frags_received.incrementAndGet();
        FragEntry entry = (FragEntry)frag_table.get(hdr.id);
        if (entry == null) {
            entry = new FragEntry(hdr.num_frags);
            FragEntry tmp2 = frag_table.putIfAbsent(hdr.id, entry);
            if (tmp2 != null) {
                entry = tmp2;
            }
        }
        entry.lock();
        try {
            entry.set(hdr.frag_id, msg);
            if (entry.isComplete()) {
                assembled_msg = entry.assembleMessage();
                frag_table.remove(hdr.id);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: unfragmented message from %s (size=%d) from %d fragments", this.local_addr, sender, assembled_msg.getLength(), entry.number_of_frags_recvd);
                }
            }
        }
        finally {
            entry.unlock();
        }
        return assembled_msg;
    }

    protected static class FragEntry {
        final Message[] fragments;
        int number_of_frags_recvd = 0;
        protected final Lock lock = new ReentrantLock();

        protected FragEntry(int tot_frags) {
            this.fragments = new Message[tot_frags];
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void set(int frag_id, Message frag) {
            if (this.fragments[frag_id] == null) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }
        }

        public boolean isComplete() {
            if (this.number_of_frags_recvd < this.fragments.length) {
                return false;
            }
            for (Message msg : this.fragments) {
                if (msg != null) continue;
                return false;
            }
            return true;
        }

        protected Message assembleMessage() {
            int combined_length = 0;
            int index = 0;
            for (Message fragment : this.fragments) {
                combined_length += fragment.getLength();
            }
            byte[] combined_buffer = new byte[combined_length];
            Message retval = this.fragments[0].copy(false);
            for (int i = 0; i < this.fragments.length; ++i) {
                Message fragment = this.fragments[i];
                this.fragments[i] = null;
                byte[] tmp = fragment.getRawBuffer();
                int length = fragment.getLength();
                int offset = fragment.getOffset();
                System.arraycopy(tmp, offset, combined_buffer, index, length);
                index += length;
            }
            retval.setBuffer(combined_buffer);
            return retval;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("[tot_frags=").append(this.fragments.length).append(", number_of_frags_recvd=").append(this.number_of_frags_recvd).append(']');
            return ret.toString();
        }
    }
}

