/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.dns;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.ping.common.OpenshiftPing;
import org.jgroups.ping.common.Utils;
import org.jgroups.ping.dns.GetServiceHosts;
import org.jgroups.ping.dns.GetServicePort;

@MBean(description="DNS based discovery protocol")
public class DnsPing
extends OpenshiftPing {
    public static final short OPENSHIFT_DNS_PING_ID = 2020;
    public static final short JGROUPS_DNS_PING_ID = 2021;
    @Property
    private String serviceName;
    private String _serviceName;
    @Property
    private int servicePort;
    private int _servicePort;

    public DnsPing() {
        super("OPENSHIFT_DNS_PING_");
    }

    @Override
    protected boolean isClusteringEnabled() {
        return this._serviceName != null;
    }

    @Override
    protected int getServerPort() {
        return this._servicePort;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this._serviceName = Utils.getSystemEnv(this.getSystemEnvName("SERVICE_NAME"), this.serviceName, true);
        if (this._serviceName == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("serviceName not set; clustering disabled", new Object[0]));
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("serviceName [%s] set; clustering enabled", this._serviceName));
        }
        this._servicePort = this.getServicePort();
    }

    @Override
    public void destroy() {
        this._serviceName = null;
        this._servicePort = 0;
        super.destroy();
    }

    private int getServicePort() {
        int svcPort = Utils.getSystemEnvInt(this.getSystemEnvName("SERVICE_PORT"));
        if (svcPort < 1 && (svcPort = this.servicePort) < 1) {
            Integer dnsPort = Utils.execute(new GetServicePort(this._serviceName), this.getOperationAttempts(), this.getOperationSleep());
            if (dnsPort != null) {
                svcPort = dnsPort;
            } else if (this.log.isWarnEnabled()) {
                this.log.warn(String.format("No DNS SRV record found for service [%s]", this._serviceName));
            }
            if (svcPort < 1) {
                svcPort = 8888;
            }
        }
        return svcPort;
    }

    private Set<String> getServiceHosts() {
        Set<String> svcHosts = Utils.execute(new GetServiceHosts(this._serviceName), this.getOperationAttempts(), this.getOperationSleep());
        if (svcHosts == null) {
            svcHosts = Collections.emptySet();
            if (this.log.isWarnEnabled()) {
                this.log.warn(String.format("No matching hosts found for service [%s]; continuing...", this._serviceName));
            }
        }
        return svcHosts;
    }

    @Override
    protected synchronized List<InetSocketAddress> doReadAll(String clusterName) {
        Set<String> serviceHosts = this.getServiceHosts();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Reading service hosts %s on port [%s]", serviceHosts, this._servicePort));
        }
        ArrayList<InetSocketAddress> retval = new ArrayList<InetSocketAddress>();
        for (String serviceHost : serviceHosts) {
            retval.add(new InetSocketAddress(serviceHost, this._servicePort));
        }
        return retval;
    }

    static {
        ClassConfigurator.addProtocol((short)2020, DnsPing.class);
    }
}

