/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateRequestCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(StateRequestCommand.class);
    public static final byte COMMAND_ID = 15;
    private Type type = Type.CANCEL_STATE_TRANSFER;
    private int topologyId;
    private Set<Integer> segments;
    private StateProvider stateProvider;

    private StateRequestCommand() {
        super(null);
    }

    public StateRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StateRequestCommand(ByteString cacheName, Type type, Address origin, int topologyId, Set<Integer> segments) {
        super(cacheName);
        this.type = type;
        this.setOrigin(origin);
        this.topologyId = topologyId;
        this.segments = segments;
    }

    public void init(StateProvider stateProvider) {
        this.stateProvider = stateProvider;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            switch (this.type) {
                case GET_TRANSACTIONS: {
                    List<TransactionInfo> transactions = this.stateProvider.getTransactionsForSegments(this.getOrigin(), this.topologyId, this.segments);
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(transactions);
                    return completableFuture;
                }
                case START_STATE_TRANSFER: {
                    this.stateProvider.startOutboundTransfer(this.getOrigin(), this.topologyId, this.segments);
                    CompletableFuture<Object> completableFuture = CompletableFutures.completedNull();
                    return completableFuture;
                }
                case CANCEL_STATE_TRANSFER: {
                    this.stateProvider.cancelOutboundTransfer(this.getOrigin(), this.topologyId, this.segments);
                    CompletableFuture<Object> completableFuture = CompletableFutures.completedNull();
                    return completableFuture;
                }
                case GET_CACHE_LISTENERS: {
                    Collection<DistributedCallable> listeners = this.stateProvider.getClusterListenersToInstall();
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(listeners);
                    return completableFuture;
                }
            }
            throw new CacheException("Unknown state request command type: " + (Object)((Object)this.type));
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.type != Type.CANCEL_STATE_TRANSFER;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum(this.type, output);
        switch (this.type) {
            case GET_TRANSACTIONS: 
            case START_STATE_TRANSFER: 
            case CANCEL_STATE_TRANSFER: {
                output.writeObject(this.getOrigin());
                MarshallUtil.marshallCollection(this.segments, output);
                return;
            }
            case GET_CACHE_LISTENERS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown state request command type: " + (Object)((Object)this.type));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.type = MarshallUtil.unmarshallEnum(input, ordinal -> Type.CACHED_VALUES[ordinal]);
        switch (this.type) {
            case GET_TRANSACTIONS: 
            case START_STATE_TRANSFER: 
            case CANCEL_STATE_TRANSFER: {
                this.setOrigin((Address)input.readObject());
                this.segments = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
                return;
            }
            case GET_CACHE_LISTENERS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown state request command type: " + (Object)((Object)this.type));
    }

    @Override
    public String toString() {
        return "StateRequestCommand{cache=" + this.cacheName + ", origin=" + this.getOrigin() + ", type=" + (Object)((Object)this.type) + ", topologyId=" + this.topologyId + ", segments=" + this.segments + '}';
    }

    public static enum Type {
        GET_TRANSACTIONS,
        GET_CACHE_LISTENERS,
        START_STATE_TRANSFER,
        CANCEL_STATE_TRANSFER;

        private static final Type[] CACHED_VALUES;

        static {
            CACHED_VALUES = Type.values();
        }
    }
}

