/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.remoting.responses.Response;
import org.jgroups.Address;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

@ThreadSafe
public class Responses
implements Iterable<Map.Entry<Address, Rsp<Response>>> {
    public static final Responses EMPTY = new Responses(Collections.emptyList());
    private final Address[] addresses;
    private final AtomicReferenceArray<Rsp<Response>> responses;
    private volatile boolean timedOut = false;

    public Responses(Collection<Address> addresses) {
        int size = addresses.size();
        this.addresses = addresses.toArray(new Address[size]);
        this.responses = new AtomicReferenceArray(size);
    }

    public static Responses suspected(Collection<Address> dests) {
        Responses responses = new Responses(dests);
        for (int i = 0; i < responses.addresses.length; ++i) {
            Rsp rsp = new Rsp();
            rsp.setSuspected();
            responses.responses.set(i, rsp);
        }
        return responses;
    }

    public Responses(RspList<Response> results) {
        int size = results.size();
        this.addresses = new Address[size];
        this.responses = new AtomicReferenceArray(size);
        int i = 0;
        for (Map.Entry e : results.entrySet()) {
            this.addresses[i] = (Address)e.getKey();
            Rsp rsp = (Rsp)e.getValue();
            if (rsp.wasReceived() || rsp.wasSuspected() || rsp.wasUnreachable()) {
                this.responses.set(i, rsp);
            }
            ++i;
        }
    }

    public void addResponse(Address sender, Rsp rsp) {
        for (int i = 0; i < this.addresses.length; ++i) {
            if (!this.addresses[i].equals(sender) || this.responses.compareAndSet(i, null, rsp)) continue;
            throw new IllegalArgumentException("Response from " + sender + " already received: " + this.responses.get(i));
        }
    }

    public boolean isMissingResponses() {
        for (int i = 0; i < this.responses.length(); ++i) {
            if (this.responses.get(i) != null) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.addresses.length;
    }

    @Override
    public Iterator<Map.Entry<Address, Rsp<Response>>> iterator() {
        return new Iterator<Map.Entry<Address, Rsp<Response>>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Responses.this.responses.length();
            }

            @Override
            public Map.Entry<Address, Rsp<Response>> next() {
                if (this.hasNext()) {
                    int index = this.i++;
                    return new SimpleImmutableEntry<Address, Rsp<Response>>(Responses.this.addresses[index], (Rsp<Response>)Responses.this.responses.get(index));
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Responses{");
        for (int i = 0; i < this.addresses.length; ++i) {
            sb.append('\n').append(this.addresses[i]).append(": ").append(this.responses.get(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public void setTimedOut() {
        this.timedOut = true;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

