/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.transaction.Transaction;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.mixed.InitialisationContextDelegate;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.TransactionalCacheWriter;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JdbcMixedStoreConfiguration.class)
public class JdbcMixedStore<K, V>
implements AdvancedLoadWriteStore<K, V>,
TransactionalCacheWriter<K, V> {
    private static final Log log = LogFactory.getLog(JdbcMixedStore.class);
    private JdbcMixedStoreConfiguration configuration;
    private JdbcBinaryStore binaryStore = new JdbcBinaryStore();
    private JdbcStringBasedStore stringStore = new JdbcStringBasedStore();
    private Map<Transaction, TxStatus> transactionStatus = new ConcurrentHashMap<Transaction, TxStatus>();
    private ConnectionFactory sharedConnectionFactory;

    @Override
    public void init(InitializationContext ctx) {
        this.configuration = (JdbcMixedStoreConfiguration)ctx.getConfiguration();
        this.binaryStore.init(new InitialisationContextDelegate(ctx, this.buildBinaryStoreConfiguration(this.configuration)));
        this.stringStore.init(new InitialisationContextDelegate(ctx, this.buildStringStoreConfiguration(this.configuration)));
    }

    @Override
    public void start() {
        ConnectionFactoryConfiguration factoryConfig = this.configuration.connectionFactory();
        this.sharedConnectionFactory = ConnectionFactory.getConnectionFactory(factoryConfig.connectionFactoryClass().getName(), this.configuration.getClass().getClassLoader());
        this.sharedConnectionFactory.start(factoryConfig, this.configuration.getClass().getClassLoader());
        this.binaryStore.initializeConnectionFactory(this.sharedConnectionFactory);
        this.binaryStore.start();
        this.stringStore.initializeConnectionFactory(this.sharedConnectionFactory);
        this.stringStore.start();
    }

    @Override
    public void stop() {
        Throwable cause = null;
        try {
            this.binaryStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        try {
            this.stringStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        try {
            this.sharedConnectionFactory.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        if (cause != null) {
            throw new PersistenceException("Exceptions occurred while stopping store", cause);
        }
    }

    @Override
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        this.binaryStore.purge(threadPool, task);
        this.stringStore.purge(threadPool, task);
    }

    @Override
    public MarshalledEntry load(Object key) {
        return this.getStore(key).load(key);
    }

    @Override
    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        this.binaryStore.process(filter, task, executor, fetchValue, fetchMetadata);
        this.stringStore.process(filter, task, executor, fetchValue, fetchMetadata);
    }

    @Override
    public void write(MarshalledEntry ed) {
        this.getStore(ed.getKey()).write(ed);
    }

    @Override
    public boolean delete(Object key) {
        return this.getStore(key).delete(key);
    }

    @Override
    public int size() {
        return this.stringStore.size() + this.binaryStore.size();
    }

    @Override
    public boolean contains(Object key) {
        return this.getStore(key).contains(key);
    }

    @Override
    public void clear() {
        this.binaryStore.clear();
        this.stringStore.clear();
    }

    @Override
    public void prepareWithModifications(Transaction transaction, BatchModification batchModification) throws PersistenceException {
        ArrayList<MarshalledEntry> stringEntries = new ArrayList<MarshalledEntry>();
        ArrayList<MarshalledEntry> binaryEntries = new ArrayList<MarshalledEntry>();
        for (MarshalledEntry entry : batchModification.getMarshalledEntries()) {
            if (this.stringStore.supportsKey(entry.getKey().getClass())) {
                stringEntries.add(entry);
                continue;
            }
            binaryEntries.add(entry);
        }
        ArrayList<Object> stringKeysToDelete = new ArrayList<Object>();
        ArrayList<Object> binaryKeysToDelete = new ArrayList<Object>();
        for (Object key : batchModification.getKeysToRemove()) {
            if (this.stringStore.supportsKey(key.getClass())) {
                stringKeysToDelete.add(key);
                continue;
            }
            binaryKeysToDelete.add(key);
        }
        TxStatus txStatus = new TxStatus();
        if (!stringEntries.isEmpty() || !stringKeysToDelete.isEmpty()) {
            this.stringStore.prepareWithModifications(transaction, batchModification);
            txStatus.registeredWithStringStore = true;
        }
        if (!binaryEntries.isEmpty() || !binaryKeysToDelete.isEmpty()) {
            this.binaryStore.prepareWithModifications(transaction, batchModification);
            txStatus.registeredWithBinaryStore = true;
        }
        if (txStatus.registeredWithBinaryStore || txStatus.registeredWithStringStore) {
            this.transactionStatus.put(transaction, txStatus);
        }
    }

    @Override
    public void commit(Transaction transaction) {
        TxStatus txStatus = this.transactionStatus.get(transaction);
        if (txStatus == null) {
            return;
        }
        if (txStatus.registeredWithBinaryStore) {
            this.binaryStore.commit(transaction);
        }
        if (txStatus.registeredWithStringStore) {
            this.stringStore.commit(transaction);
        }
        this.transactionStatus.remove(transaction);
    }

    @Override
    public void rollback(Transaction transaction) {
        TxStatus txStatus = this.transactionStatus.get(transaction);
        if (txStatus == null) {
            return;
        }
        if (txStatus.registeredWithBinaryStore) {
            this.binaryStore.rollback(transaction);
        }
        if (txStatus.registeredWithStringStore) {
            this.stringStore.rollback(transaction);
        }
        this.transactionStatus.remove(transaction);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.sharedConnectionFactory;
    }

    public JdbcBinaryStore getBinaryStore() {
        return this.binaryStore;
    }

    public JdbcStringBasedStore getStringStore() {
        return this.stringStore;
    }

    private JdbcStringBasedStoreConfiguration buildStringStoreConfiguration(JdbcMixedStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder stringBuilder = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class).manageConnectionFactory(false);
        stringBuilder.key2StringMapper(configuration.key2StringMapper()).table().read(configuration.stringTable());
        return stringBuilder.create();
    }

    private JdbcBinaryStoreConfiguration buildBinaryStoreConfiguration(JdbcMixedStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcBinaryStoreConfigurationBuilder binaryBuilder = (JdbcBinaryStoreConfigurationBuilder)builder.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class).manageConnectionFactory(false);
        binaryBuilder.table().read(configuration.binaryTable());
        return binaryBuilder.create();
    }

    private AdvancedLoadWriteStore getStore(Object key) {
        return this.stringStore.supportsKey(key.getClass()) ? this.stringStore : this.binaryStore;
    }

    public JdbcMixedStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private class TxStatus {
        boolean registeredWithStringStore = false;
        boolean registeredWithBinaryStore = false;

        private TxStatus() {
        }
    }
}

