/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SelfDeliverFilter;
import org.infinispan.remoting.responses.TimeoutValidationResponseFilter;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;

public abstract class BaseRpcInterceptor
extends DDAsyncInterceptor {
    protected boolean trace = this.getLog().isTraceEnabled();
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;
    protected RpcOptions staggeredOptions;
    protected RpcOptions defaultSyncOptions;
    protected RpcOptions defaultAsyncOptions;

    protected abstract Log getLog();

    @Inject
    public void inject(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        this.staggeredOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE, DeliverOrder.NONE).responseFilter(new ResponseFilter(){

            @Override
            public boolean isAcceptable(Response response, Address sender) {
                return response.isValid() || response instanceof ExceptionResponse;
            }

            @Override
            public boolean needMoreResponses() {
                return true;
            }
        }).build();
        this.defaultSyncOptions = this.rpcManager.getDefaultRpcOptions(true);
        this.defaultAsyncOptions = this.rpcManager.getDefaultRpcOptions(false);
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.getLog().trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        if (!ctx.isOriginLocal()) {
            return false;
        }
        LocalTxInvocationContext localCtx = (LocalTxInvocationContext)ctx;
        if (((LocalTransaction)localCtx.getCacheTransaction()).getStateTransferFlag() == Flag.PUT_FOR_STATE_TRANSFER) {
            return false;
        }
        boolean bl = shouldInvokeRemotely = ctx.hasModifications() || !localCtx.getRemoteLocksAcquired().isEmpty() || ((LocalTransaction)localCtx.getCacheTransaction()).getTopologyId() != this.rpcManager.getTopologyId();
        if (this.trace) {
            this.getLog().tracef("Should invoke remotely? %b. hasModifications=%b, hasRemoteLocksAcquired=%b", (Object)shouldInvokeRemotely, (Object)ctx.hasModifications(), (Object)(!localCtx.getRemoteLocksAcquired().isEmpty() ? 1 : 0));
        }
        return shouldInvokeRemotely;
    }

    protected static void transactionRemotelyPrepared(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markPrepareSent();
        }
    }

    protected static void totalOrderTxCommit(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static void totalOrderTxRollback(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static boolean shouldTotalOrderRollbackBeInvokedRemotely(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && ((LocalTransaction)ctx.getCacheTransaction()).isPrepareSent() && !((LocalTransaction)ctx.getCacheTransaction()).isCommitOrRollbackSent();
    }

    protected CompletableFuture<Object> totalOrderPrepare(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients, TimeoutValidationResponseFilter responseFilter) {
        try {
            HashSet<Address> realRecipients = null;
            if (recipients != null) {
                realRecipients = new HashSet<Address>(recipients);
                realRecipients.add(this.rpcManager.getAddress());
            }
            CompletableFuture<Map<Address, Response>> remoteInvocation = this.internalTotalOrderPrepare(realRecipients, command, responseFilter);
            return remoteInvocation.handle((responses, t) -> {
                BaseRpcInterceptor.transactionRemotelyPrepared(ctx);
                CompletableFutures.rethrowException(t);
                return null;
            });
        }
        catch (Throwable t2) {
            BaseRpcInterceptor.transactionRemotelyPrepared(ctx);
            throw t2;
        }
    }

    private CompletableFuture<Map<Address, Response>> internalTotalOrderPrepare(Collection<Address> recipients, PrepareCommand prepareCommand, TimeoutValidationResponseFilter responseFilter) {
        if (this.defaultSynchronous) {
            RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.TOTAL);
            if (responseFilter != null) {
                builder.responseFilter(responseFilter);
            }
            CompletableFuture<Map<Address, Response>> remoteInvocation = this.rpcManager.invokeRemotelyAsync(recipients, prepareCommand, builder.build());
            if (responseFilter == null) {
                return remoteInvocation;
            }
            return remoteInvocation.thenApply(responses -> {
                responseFilter.validate();
                return responses;
            });
        }
        RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.ASYNCHRONOUS, DeliverOrder.TOTAL);
        return this.rpcManager.invokeRemotelyAsync(recipients, prepareCommand, builder.build());
    }

    protected final boolean isSyncCommitPhase() {
        return this.cacheConfiguration.transaction().syncCommitPhase();
    }

    protected final TimeoutValidationResponseFilter getSelfDeliverFilter() {
        return new SelfDeliverFilter(this.rpcManager.getAddress());
    }
}

