/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.MemoryAddressHash;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.StripedLock;
import org.infinispan.container.offheap.UnsafeHolder;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import sun.misc.Unsafe;

public class OffHeapDataContainer
implements DataContainer<WrappedBytes, WrappedBytes> {
    private static final Log log = LogFactory.getLog(OffHeapDataContainer.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    private final AtomicLong size = new AtomicLong();
    private final int lockCount = OffHeapDataContainer.nextPowerOfTwo(Runtime.getRuntime().availableProcessors()) << 1;
    private final int memoryAddressCount;
    private final StripedLock locks;
    private final MemoryAddressHash memoryLookup;
    private OffHeapMemoryAllocator allocator;
    private OffHeapEntryFactory offHeapEntryFactory;
    private InternalEntryFactory internalEntryFactory;
    private TimeService timeService;
    private PassivationManager passivator;
    private boolean dellocated = false;
    private static final int MAX_LOCK_COUNT = 0x40000000;

    static int nextPowerOfTwo(int target) {
        int n = target - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public OffHeapDataContainer(int desiredSize) {
        int memoryAddresses;
        int n = memoryAddresses = desiredSize >= 0x40000000 ? 0x40000000 : this.lockCount;
        while (memoryAddresses < desiredSize) {
            memoryAddresses <<= 1;
        }
        this.memoryAddressCount = memoryAddresses;
        this.memoryLookup = new MemoryAddressHash(this.memoryAddressCount);
        this.locks = new StripedLock(this.lockCount);
    }

    @Inject
    public void inject(PassivationManager passivator, OffHeapEntryFactory offHeapEntryFactory, OffHeapMemoryAllocator allocator, TimeService timeService, InternalEntryFactory internalEntryFactory) {
        this.passivator = passivator;
        this.internalEntryFactory = internalEntryFactory;
        this.allocator = allocator;
        this.offHeapEntryFactory = offHeapEntryFactory;
        this.timeService = timeService;
    }

    @Stop(priority=0x7FFFFFFF)
    public void deallocate() {
        this.locks.lockAll();
        try {
            if (this.size.get() != 0L) {
                log.warn("Container was not cleared before deallocating memory lookup tables!  Memory leak will have occurred!");
            }
            this.clear();
            this.memoryLookup.deallocate();
            this.dellocated = true;
        }
        finally {
            this.locks.unlockAll();
        }
    }

    static WrappedByteArray toWrapper(Object obj) {
        if (obj instanceof WrappedByteArray) {
            return (WrappedByteArray)obj;
        }
        throw new IllegalArgumentException("Require WrappedByteArray: got " + obj.getClass());
    }

    private void checkDeallocation() {
        if (this.dellocated) {
            throw new IllegalStateException("Container was already shut down!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> get(Object k) {
        Lock lock = this.locks.getLock(k).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(k);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            WrappedByteArray wrappedKey = OffHeapDataContainer.toWrapper(k);
            while (address != 0L) {
                long nextAddress = UNSAFE.getLong(address);
                long realAddress = address + 8L;
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(realAddress);
                if (wrappedKey.equalsWrappedBytes((WrappedBytes)ice.getKey())) {
                    InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = ice;
                    return internalCacheEntry;
                }
                address = nextAddress;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> peek(Object k) {
        return this.get(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long newAddress = this.offHeapEntryFactory.create(key, value, metadata);
            long address = this.memoryLookup.getMemoryAddress(key);
            boolean shouldCreate = false;
            if (address == 0L) {
                this.memoryLookup.putMemoryAddress(key, newAddress);
            } else {
                boolean foundKey = false;
                long prevAddress = 0L;
                while (address != 0L) {
                    long nextAddress = UNSAFE.getLong(address);
                    long realAddress = address + 8L;
                    if (!foundKey && this.offHeapEntryFactory.equalsKey(realAddress, key)) {
                        this.allocator.deallocate(address);
                        foundKey = true;
                        if (prevAddress == 0L) {
                            if (nextAddress == 0L) {
                                shouldCreate = true;
                            } else {
                                this.memoryLookup.putMemoryAddress(key, nextAddress);
                            }
                        } else {
                            UNSAFE.putLong(prevAddress, nextAddress);
                            address = nextAddress;
                            continue;
                        }
                    }
                    prevAddress = address;
                    address = nextAddress;
                }
                if (!foundKey) {
                    this.size.incrementAndGet();
                }
                if (shouldCreate) {
                    this.memoryLookup.putMemoryAddress(key, newAddress);
                } else {
                    UNSAFE.putLong(prevAddress, newAddress);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object k) {
        Lock lock = this.locks.getLock(k).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(k);
            if (address == 0L) {
                boolean bl = false;
                return bl;
            }
            WrappedByteArray wba = OffHeapDataContainer.toWrapper(k);
            while (address != 0L) {
                long nextAddress = UNSAFE.getLong(address);
                long realAddress = address + 8L;
                if (this.offHeapEntryFactory.equalsKey(realAddress, wba)) {
                    boolean bl = true;
                    return bl;
                }
                address = nextAddress;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> remove(Object key) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            WrappedByteArray wba = OffHeapDataContainer.toWrapper(key);
            long prevAddress = 0L;
            while (address != 0L) {
                long nextAddress = UNSAFE.getLong(address);
                long realAddress = address + 8L;
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(realAddress);
                if (((WrappedBytes)ice.getKey()).equals(wba)) {
                    this.allocator.deallocate(address);
                    if (prevAddress != 0L) {
                        UNSAFE.putLong(prevAddress, nextAddress);
                    } else {
                        this.memoryLookup.putMemoryAddress(key, nextAddress);
                    }
                    this.size.decrementAndGet();
                    InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = ice;
                    return internalCacheEntry;
                }
                prevAddress = address;
                address = nextAddress;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        long time = this.timeService.time();
        long count = this.entryStream().filter(e -> !e.isExpired(time)).count();
        if (count > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    @Override
    public int sizeIncludingExpired() {
        long currentSize = this.size.get();
        if (currentSize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)currentSize;
    }

    @Override
    public void clear() {
        this.locks.lockAll();
        try {
            this.checkDeallocation();
            this.memoryLookup.toStreamRemoved().forEach((long address) -> {
                while (address != 0L) {
                    long nextAddress = UNSAFE.getLong(address);
                    this.allocator.deallocate(address);
                    address = nextAddress;
                }
            });
            this.size.set(0L);
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @Override
    public Set<WrappedBytes> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<WrappedBytes> values() {
        return new ValueCollection();
    }

    @Override
    public Set<InternalCacheEntry<WrappedBytes, WrappedBytes>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void evict(WrappedBytes key) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            this.passivator.passivate(this.get(key));
            this.remove(key);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            InternalCacheEntry<WrappedBytes, WrappedBytes> prev = this.get(key);
            InternalCacheEntry<WrappedBytes, WrappedBytes> result = action.compute(key, prev, this.internalEntryFactory);
            if (result != null) {
                this.put((WrappedBytes)result.getKey(), (WrappedBytes)result.getValue(), result.getMetadata());
            } else {
                this.remove(key);
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = result;
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(Consumer<InternalCacheEntry<WrappedBytes, WrappedBytes>> consumer) {
        for (int i = 0; i < this.lockCount; ++i) {
            Lock lock = this.locks.getLockWithOffset(i).readLock();
            lock.lock();
            try {
                this.checkDeallocation();
                for (int j = i; j < this.memoryAddressCount; j += this.lockCount) {
                    long address = this.memoryLookup.getMemoryAddressOffset(j);
                    while (address != 0L) {
                        long nextAddress = UNSAFE.getLong(address);
                        long realAddress = address + 8L;
                        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(realAddress);
                        consumer.accept(ice);
                        address = nextAddress;
                    }
                }
                continue;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void executeTask(KeyFilter<? super WrappedBytes> filter, BiConsumer<? super WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>> action) throws InterruptedException {
        this.executeTask(ice -> {
            if (filter.accept((WrappedBytes)ice.getKey())) {
                action.accept((WrappedBytes)ice.getKey(), (InternalCacheEntry<WrappedBytes, WrappedBytes>)ice);
            }
        });
    }

    @Override
    public void executeTask(KeyValueFilter<? super WrappedBytes, ? super WrappedBytes> filter, BiConsumer<? super WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>> action) throws InterruptedException {
        this.executeTask(ice -> {
            if (filter.accept((WrappedBytes)ice.getKey(), (WrappedBytes)ice.getValue(), ice.getMetadata())) {
                action.accept((WrappedBytes)ice.getKey(), (InternalCacheEntry<WrappedBytes, WrappedBytes>)ice);
            }
        });
    }

    private Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> entryStream() {
        int limit = this.memoryAddressCount / this.lockCount;
        return IntStream.range(0, this.lockCount).boxed().flatMap(l -> {
            int value = l;
            return LongStream.iterate(value, i -> i + (long)this.lockCount).limit(limit).boxed().flatMap(a -> {
                Lock lock = this.locks.getLockWithOffset(value).readLock();
                lock.lock();
                try {
                    this.checkDeallocation();
                    long address = this.memoryLookup.getMemoryAddressOffset(a.intValue());
                    if (address == 0L) {
                        Stream stream = Stream.empty();
                        return stream;
                    }
                    Stream.Builder<InternalCacheEntry<WrappedBytes, WrappedBytes>> builder = Stream.builder();
                    while (address != 0L) {
                        long nextAddress;
                        do {
                            nextAddress = UNSAFE.getLong(address);
                            long realAddress = address + 8L;
                            builder.accept(this.offHeapEntryFactory.fromMemory(realAddress));
                        } while ((address = nextAddress) != 0L);
                    }
                    Stream stream = builder.build();
                    return stream;
                }
                finally {
                    lock.unlock();
                }
            });
        });
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
        long time = this.timeService.time();
        return this.entryStream().filter(e -> !e.isExpired(time)).iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iteratorIncludingExpired() {
        return this.entryStream().iterator();
    }

    class EntrySet
    extends AbstractSet<InternalCacheEntry<WrappedBytes, WrappedBytes>> {
        EntrySet() {
        }

        @Override
        public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
            return this.stream().iterator();
        }

        @Override
        public int size() {
            return OffHeapDataContainer.this.size();
        }

        @Override
        public void forEach(Consumer<? super InternalCacheEntry<WrappedBytes, WrappedBytes>> action) {
            this.stream().forEach(action);
        }

        @Override
        public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> stream() {
            return OffHeapDataContainer.this.entryStream();
        }

        @Override
        public Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> parallelStream() {
            return (Stream)this.stream().parallel();
        }
    }

    class KeySet
    extends ValueCollection
    implements Set<WrappedBytes> {
        KeySet() {
        }

        @Override
        public Stream<WrappedBytes> stream() {
            return OffHeapDataContainer.this.entryStream().map(Map.Entry::getKey);
        }

        @Override
        public boolean contains(Object o) {
            return OffHeapDataContainer.this.containsKey(o);
        }
    }

    class ValueCollection
    extends AbstractCollection<WrappedBytes> {
        ValueCollection() {
        }

        @Override
        public Iterator<WrappedBytes> iterator() {
            return this.stream().iterator();
        }

        @Override
        public void forEach(Consumer<? super WrappedBytes> action) {
            this.stream().forEach(action);
        }

        @Override
        public Spliterator<WrappedBytes> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public Stream<WrappedBytes> stream() {
            return OffHeapDataContainer.this.entryStream().map(Map.Entry::getValue);
        }

        @Override
        public Stream<WrappedBytes> parallelStream() {
            return (Stream)this.stream().parallel();
        }

        @Override
        public int size() {
            return OffHeapDataContainer.this.size();
        }
    }
}

