/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseClusteredReadCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextFactory icf;
    private CommandsFactory commandsFactory;
    private AsyncInterceptorChain invoker;
    private InternalEntryFactory entryFactory;
    private Equivalence keyEquivalence;
    private boolean isWrite;

    private ClusteredGetCommand() {
        super(null, 0L);
    }

    public ClusteredGetCommand(ByteString cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetCommand(Object key, ByteString cacheName, long flags, Equivalence keyEquivalence) {
        super(cacheName, flags);
        this.key = key;
        this.keyEquivalence = keyEquivalence;
        this.isWrite = false;
    }

    public void initialize(InvocationContextFactory icf, CommandsFactory commandsFactory, InternalEntryFactory entryFactory, AsyncInterceptorChain interceptorChain, Equivalence keyEquivalence) {
        this.icf = icf;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.entryFactory = entryFactory;
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        long flagBitSet = EnumUtil.bitSetOf(Flag.SKIP_REMOTE_LOOKUP);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(this.key, EnumUtil.mergeBitSets(flagBitSet, this.getFlagsBitSet()));
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = this.icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CompletableFuture<Object> future = this.invoker.invokeAsync(invocationContext, command);
        return future.thenApply(rv -> {
            if (trace) {
                log.tracef("Return value for key=%s is %s", this.key, rv);
            }
            if (rv instanceof MVCCEntry) {
                MVCCEntry mvccEntry = (MVCCEntry)rv;
                return this.entryFactory.createValue(mvccEntry);
            }
            if (rv instanceof InternalCacheEntry) {
                InternalCacheEntry internalCacheEntry = (InternalCacheEntry)rv;
                return internalCacheEntry.toInternalCacheValue();
            }
            return rv;
        });
    }

    @Deprecated
    public GlobalTransaction getGlobalTransaction() {
        return null;
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.setFlagsBitSet(input.readLong());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        if (this.key != null) {
            if (this.keyEquivalence != null) {
                if (!this.keyEquivalence.equals(this.key, that.key)) return false;
                return true;
            }
        } else {
            if (that.key != null) return false;
            return true;
        }
        if (this.key.equals(that.key)) return true;
        return false;
    }

    public int hashCode() {
        int result = this.key != null ? (this.keyEquivalence != null ? this.keyEquivalence.hashCode(this.key) : this.key.hashCode()) : 0;
        return result;
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.printFlags() + "}";
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public void setWrite(boolean write) {
        this.isWrite = write;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

