/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.EnumSet;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.cache.impl.TypeConverterDelegatingAdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.compat.DoubleTypeConverter;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CompatibilityAdvancedCache<K, V>
extends TypeConverterDelegatingAdvancedCache<K, V> {
    private TypeConverter<K, V, K, V> hotRodConverter;
    private TypeConverter<K, V, K, V> memcachedConverter;
    private TypeConverter<K, V, K, V> embeddedConverter;

    public CompatibilityAdvancedCache(AdvancedCache<K, V> cache, Marshaller marshaller, TypeConverter converter) {
        super(cache, (AdvancedCache<K, V> c) -> new CompatibilityAdvancedCache(c, marshaller, converter), converter);
        Collection<TypeConverter> converters = ServiceFinder.load(TypeConverter.class, new ClassLoader[0]);
        for (TypeConverter foundConverter : converters) {
            if (foundConverter.supportsInvocation(Flag.OPERATION_HOTROD)) {
                this.hotRodConverter = CompatibilityAdvancedCache.setConverterMarshaller(new DoubleTypeConverter(foundConverter, converter), marshaller);
                continue;
            }
            if (!foundConverter.supportsInvocation(Flag.OPERATION_MEMCACHED)) continue;
            this.memcachedConverter = CompatibilityAdvancedCache.setConverterMarshaller(new DoubleTypeConverter(foundConverter, converter), marshaller);
        }
        this.embeddedConverter = CompatibilityAdvancedCache.setConverterMarshaller(new DoubleTypeConverter(new EmbeddedTypeConverter(), converter), marshaller);
    }

    private static TypeConverter setConverterMarshaller(TypeConverter converter, Marshaller marshaller) {
        if (marshaller != null) {
            converter.setMarshaller(marshaller);
        }
        return converter;
    }

    @Override
    protected TypeConverter getConverter() {
        Cache cache = this.cache;
        while (cache instanceof AbstractDelegatingCache && !(cache instanceof DecoratedCache)) {
            cache = ((AbstractDelegatingCache)cache).getDelegate();
        }
        if (cache instanceof DecoratedCache) {
            EnumSet<Flag> flags = ((DecoratedCache)cache).getFlags();
            if (flags.contains((Object)Flag.OPERATION_HOTROD)) {
                return this.hotRodConverter;
            }
            if (flags.contains((Object)Flag.OPERATION_MEMCACHED)) {
                return this.memcachedConverter;
            }
        }
        return this.embeddedConverter;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        AdvancedCache returned = super.withFlags(flags);
        if (returned != this && returned instanceof CompatibilityAdvancedCache) {
            CompatibilityAdvancedCache cac = (CompatibilityAdvancedCache)returned;
            cac.hotRodConverter = this.hotRodConverter;
            cac.memcachedConverter = this.memcachedConverter;
            cac.embeddedConverter = this.embeddedConverter;
        }
        return returned;
    }

    private static class EmbeddedTypeConverter
    implements TypeConverter<Object, Object, Object, Object> {
        private static final Log log = LogFactory.getLog(EmbeddedTypeConverter.class);
        private Marshaller marshaller;

        private EmbeddedTypeConverter() {
        }

        @Override
        public Object boxKey(Object key) {
            return key;
        }

        @Override
        public Object boxValue(Object value) {
            return value;
        }

        @Override
        public Object unboxKey(Object target) {
            return this.unboxValue(target);
        }

        @Override
        public Object unboxValue(Object target) {
            block6: {
                if (this.marshaller != null && target instanceof byte[]) {
                    try {
                        return this.marshaller.objectFromByteBuffer((byte[])target);
                    }
                    catch (Exception e) {
                        throw new CacheException("Unable to unmarshall return value");
                    }
                }
                if (target instanceof byte[]) {
                    try {
                        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])target));
                        return ois.readObject();
                    }
                    catch (Exception ee) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debugf("Standard deserialization not in use for %s", (Object)Util.printArray((byte[])target));
                    }
                }
            }
            return target;
        }

        @Override
        public boolean supportsInvocation(Flag flag) {
            return false;
        }

        @Override
        public void setMarshaller(Marshaller marshaller) {
            this.marshaller = marshaller;
        }
    }
}

