/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.leveldb.LevelDBStore;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationSerializer;

@ConfigurationFor(value=LevelDBStore.class)
@BuiltBy(value=LevelDBStoreConfigurationBuilder.class)
@SerializedWith(value=LevelDBStoreConfigurationSerializer.class)
public class LevelDBStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder("location", "Infinispan-LevelDBStore/data").immutable().xmlName("path").build();
    static final AttributeDefinition<String> EXPIRED_LOCATION = AttributeDefinition.builder("expiredLocation", "Infinispan-LevelDBStore/expired").immutable().autoPersist(false).xmlName("path").build();
    static final AttributeDefinition<ImplementationType> IMPLEMENTATION_TYPE = AttributeDefinition.builder("implementationType", ImplementationType.AUTO).immutable().autoPersist(false).build();
    static final AttributeDefinition<CompressionType> COMPRESSION_TYPE = AttributeDefinition.builder("compressionType", CompressionType.NONE).immutable().autoPersist(false).build();
    static final AttributeDefinition<Integer> BLOCK_SIZE = AttributeDefinition.builder("blockSize", 0).immutable().build();
    static final AttributeDefinition<Long> CACHE_SIZE = AttributeDefinition.builder("cacheSize", 0L).immutable().build();
    static final AttributeDefinition<Integer> EXPIRY_QUEUE_SIZE = AttributeDefinition.builder("expiryQueueSize", 10000).immutable().autoPersist(false).build();
    static final AttributeDefinition<Integer> CLEAR_THRESHOLD = AttributeDefinition.builder("clearThreshold", 10000).immutable().build();
    private final Attribute<String> location;
    private final Attribute<String> expiredLocation;
    private final Attribute<ImplementationType> implementationType;
    private final Attribute<CompressionType> compressionType;
    private final Attribute<Integer> blockSize;
    private final Attribute<Long> cacheSize;
    private final Attribute<Integer> expiryQueueSize;
    private final Attribute<Integer> clearThreshold;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LevelDBStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), LOCATION, EXPIRED_LOCATION, IMPLEMENTATION_TYPE, COMPRESSION_TYPE, BLOCK_SIZE, CACHE_SIZE, EXPIRY_QUEUE_SIZE, CLEAR_THRESHOLD);
    }

    public LevelDBStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(attributes, async, singletonStore);
        this.location = attributes.attribute(LOCATION);
        this.expiredLocation = attributes.attribute(EXPIRED_LOCATION);
        this.implementationType = attributes.attribute(IMPLEMENTATION_TYPE);
        this.compressionType = attributes.attribute(COMPRESSION_TYPE);
        this.blockSize = attributes.attribute(BLOCK_SIZE);
        this.cacheSize = attributes.attribute(CACHE_SIZE);
        this.expiryQueueSize = attributes.attribute(EXPIRY_QUEUE_SIZE);
        this.clearThreshold = attributes.attribute(CLEAR_THRESHOLD);
    }

    public String location() {
        return this.location.get();
    }

    public String expiredLocation() {
        return this.expiredLocation.get();
    }

    public ImplementationType implementationType() {
        return this.implementationType.get();
    }

    public CompressionType compressionType() {
        return this.compressionType.get();
    }

    public Integer blockSize() {
        return this.blockSize.get();
    }

    public Long cacheSize() {
        return this.cacheSize.get();
    }

    public int expiryQueueSize() {
        return this.expiryQueueSize.get();
    }

    public int clearThreshold() {
        return this.clearThreshold.get();
    }

    public static enum ImplementationType {
        AUTO,
        JAVA,
        JNI;

    }
}

