/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractJCachingProvider
implements CachingProvider {
    private static final Log log = LogFactory.getLog(AbstractJCachingProvider.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<ClassLoader, Map<URI, CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, CacheManager>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI globalUri = uri == null ? this.getDefaultURI() : uri;
        ClassLoader globalClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties globalProperties = properties == null ? new Properties() : properties;
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            CacheManager cacheManager;
            Map<URI, CacheManager> map2 = this.cacheManagers.get(globalClassLoader);
            if (map2 == null) {
                if (trace) {
                    log.tracef("No cache managers registered under '%s'", (Object)globalUri);
                }
                map2 = new HashMap<URI, CacheManager>();
                this.cacheManagers.put(globalClassLoader, map2);
            }
            if ((cacheManager = map2.get(globalUri)) == null || cacheManager.isClosed()) {
                cacheManager = this.createCacheManager(globalClassLoader, globalUri, globalProperties);
                if (trace) {
                    log.tracef("Created '%s' cache manager", (Object)globalUri);
                }
                map2.put(globalUri, cacheManager);
            }
            return cacheManager;
        }
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map<URI, CacheManager> map2 : this.cacheManagers.values()) {
                this.close(map2);
            }
            this.cacheManagers.clear();
            if (trace) {
                log.tracef("All cache managers have been removed", new Object[0]);
            }
        }
    }

    public void close(ClassLoader classLoader) {
        this.close(null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            if (uri != null) {
                Map<URI, CacheManager> map2 = this.cacheManagers.get(classLoader);
                if (map2 != null) {
                    CacheManager cacheManager = map2.remove(uri);
                    if (map2.isEmpty()) {
                        this.cacheManagers.remove(classLoader);
                    }
                    if (cacheManager != null) {
                        cacheManager.close();
                    }
                }
            } else {
                Map<URI, CacheManager> cacheManagersToClose = this.cacheManagers.remove(classLoader);
                if (cacheManagersToClose != null) {
                    this.close(cacheManagersToClose);
                }
            }
        }
    }

    private void close(Map<URI, CacheManager> map) {
        for (CacheManager cacheManager : map.values()) {
            cacheManager.close();
            if (!trace) continue;
            log.tracef("Shutdown cache manager '%s'", (Object)cacheManager.getURI());
        }
    }

    protected abstract CacheManager createCacheManager(ClassLoader var1, URI var2, Properties var3);
}

