/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    protected VersionGenerator versionGenerator;
    private static final Log log = LogFactory.getLog(VersionedEntryWrappingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void initialize(VersionGenerator versionGenerator) {
        this.versionGenerator = versionGenerator;
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        VersionedPrepareCommand versionedPrepareCommand = (VersionedPrepareCommand)command;
        if (ctx.isOriginLocal()) {
            versionedPrepareCommand.setVersionsSeen(((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead());
        }
        this.wrapEntriesForPrepare(ctx, command);
        EntryVersionsMap originVersionData = ctx.isOriginLocal() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer() ? this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, versionedPrepareCommand) : null;
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            EntryVersionsMap newVersionData = txInvocationContext.isOriginLocal() ? originVersionData : this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, txInvocationContext, versionedPrepareCommand);
            boolean onePhaseCommit = ((PrepareCommand)rCommand).isOnePhaseCommit();
            if (onePhaseCommit) {
                ((AbstractCacheTransaction)txInvocationContext.getCacheTransaction()).setUpdatedEntryVersions(versionedPrepareCommand.getVersionsSeen());
            }
            if (onePhaseCommit) {
                this.commitContextEntries(txInvocationContext, null, null);
            }
            if (newVersionData != null) {
                return CompletableFuture.completedFuture(newVersionData);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (!rCtx.isOriginLocal()) {
                VersionedCommitCommand versionedCommitCommand = (VersionedCommitCommand)rCommand;
                ((AbstractCacheTransaction)((TxInvocationContext)rCtx).getCacheTransaction()).setUpdatedEntryVersions(versionedCommitCommand.getUpdatedVersions());
            }
            this.commitContextEntries(rCtx, null, null);
            return null;
        });
        VersionedCommitCommand versionedCommitCommand = (VersionedCommitCommand)command;
        if (ctx.isOriginLocal()) {
            versionedCommitCommand.setUpdatedVersions(((AbstractCacheTransaction)ctx.getCacheTransaction()).getUpdatedEntryVersions());
        }
        return ctx.continueInvocation();
    }

    @Override
    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata, Flag stateTransferFlag, boolean l1Invalidation) {
        if (ctx.isInTxScope() && stateTransferFlag == null) {
            EntryVersion updatedEntryVersion = (EntryVersion)((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions().get(entry.getKey());
            Metadata commitMetadata = updatedEntryVersion != null ? (metadata == null && entry.getMetadata() == null ? new EmbeddedMetadata.Builder().version(updatedEntryVersion).build() : (metadata != null ? metadata.builder().version(updatedEntryVersion).build() : entry.getMetadata().builder().version(updatedEntryVersion).build())) : (metadata != null ? metadata : entry.getMetadata());
            this.cdl.commitEntry(entry, commitMetadata, command, ctx, null, l1Invalidation);
        } else {
            this.cdl.commitEntry(entry, entry.getMetadata(), command, ctx, stateTransferFlag, l1Invalidation);
        }
    }
}

