/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.StateChangingEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryFactoryImpl
implements EntryFactory {
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean useRepeatableRead;
    private DataContainer container;
    private boolean isL1Enabled;
    private Configuration configuration;
    private DistributionManager distributionManager;
    private TimeService timeService;

    @Inject
    public void injectDependencies(DataContainer dataContainer, Configuration configuration, DistributionManager distributionManager, TimeService timeService) {
        this.container = dataContainer;
        this.configuration = configuration;
        this.distributionManager = distributionManager;
        this.timeService = timeService;
    }

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.isL1Enabled = this.configuration.clustering().l1().enabled();
    }

    @Override
    public final CacheEntry wrapEntryForReading(InvocationContext ctx, Object key, CacheEntry existing) {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry == null) {
            CacheEntry cacheEntry2 = cacheEntry = existing != null ? existing : this.getFromContainer(key, false, false);
            if (this.useRepeatableRead) {
                cacheEntry = this.createWrappedEntry(key, cacheEntry, ctx, false);
            }
            if (cacheEntry != null) {
                ctx.putLookedUpEntry(key, cacheEntry);
            }
        }
        if (trace) {
            log.tracef("Wrap %s for read. Entry=%s", (Object)Util.toStr(key), (Object)cacheEntry);
        }
        return cacheEntry;
    }

    @Override
    public MVCCEntry wrapEntryForWriting(InvocationContext ctx, Object key, EntryFactory.Wrap wrap, boolean skipRead, boolean ignoreOwnership) {
        MVCCEntry mvccEntry;
        CacheEntry contextEntry;
        if (wrap == EntryFactory.Wrap.STORE) {
            throw new IllegalStateException("wrapEntryForWriting must create a MVCCEntry");
        }
        if (this.useRepeatableRead) {
            wrap = EntryFactory.Wrap.WRAP_ALL;
        }
        if ((contextEntry = this.getFromContext(ctx, key)) instanceof MVCCEntry) {
            mvccEntry = this.assertRepeatableReadEntry(contextEntry);
        } else if (contextEntry != null) {
            mvccEntry = this.createWrappedEntry(key, contextEntry, ctx, skipRead);
            ctx.putLookedUpEntry(key, mvccEntry);
            if (trace) {
                log.tracef("Updated context entry %s", (Object)contextEntry);
            }
        } else {
            InternalCacheEntry ice = this.getFromContainer(key, ignoreOwnership, true);
            if (ice == null && wrap == EntryFactory.Wrap.WRAP_NON_NULL) {
                mvccEntry = null;
            } else {
                mvccEntry = this.createWrappedEntry(key, ice, ctx, skipRead);
                if (ice == null) {
                    mvccEntry.setCreated(true);
                }
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s", (Object)mvccEntry);
                }
            }
        }
        if (mvccEntry != null) {
            mvccEntry.copyForUpdate();
        }
        return mvccEntry;
    }

    @Override
    public boolean wrapExternalEntry(InvocationContext ctx, Object key, CacheEntry externalEntry, EntryFactory.Wrap wrap, boolean skipRead) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (contextEntry instanceof MVCCEntry) {
            if (!contextEntry.isNull() || contextEntry.skipLookup()) {
                if (trace) {
                    log.tracef("Ignored update for context entry %s", (Object)contextEntry);
                }
                return false;
            }
            contextEntry.setValue(externalEntry.getValue());
            contextEntry.setCreated(externalEntry.getCreated());
            contextEntry.setLastUsed(externalEntry.getLastUsed());
            contextEntry.setMetadata(externalEntry.getMetadata());
            if (trace) {
                log.tracef("Updated context entry %s", (Object)contextEntry);
            }
            return true;
        }
        if (contextEntry instanceof DeltaAwareCacheEntry) {
            if (contextEntry.getValue() != null) {
                if (trace) {
                    log.tracef("Ignored update for context entry %s", (Object)contextEntry);
                }
                return false;
            }
            contextEntry.setValue(externalEntry.getValue());
            contextEntry.setMetadata(externalEntry.getMetadata());
            if (trace) {
                log.tracef("Updated context entry %s", (Object)contextEntry);
            }
            return true;
        }
        if (contextEntry == null || contextEntry.isNull()) {
            if (this.useRepeatableRead) {
                wrap = EntryFactory.Wrap.WRAP_ALL;
            }
            if (externalEntry == null && wrap != EntryFactory.Wrap.WRAP_ALL) {
                if (trace) {
                    log.tracef("Skipping update with null value for key %s", key);
                }
                return false;
            }
            if (wrap == EntryFactory.Wrap.STORE) {
                ctx.putLookedUpEntry(key, externalEntry);
            } else {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, externalEntry, ctx, skipRead);
                ctx.putLookedUpEntry(key, mvccEntry);
            }
            if (trace) {
                log.tracef("Updated context entry %s", (Object)externalEntry);
            }
            return true;
        }
        if (trace) {
            log.tracef("Skipping update with null value for key %s", key);
        }
        return false;
    }

    @Override
    public CacheEntry wrapEntryForDelta(InvocationContext ctx, Object deltaKey, Delta delta) {
        DeltaAwareCacheEntry deltaAwareEntry;
        CacheEntry cacheEntry = this.getFromContext(ctx, deltaKey);
        if (cacheEntry instanceof DeltaAwareCacheEntry) {
            deltaAwareEntry = (DeltaAwareCacheEntry)cacheEntry;
        } else if (cacheEntry != null) {
            deltaAwareEntry = this.createWrappedDeltaEntry(deltaKey, (DeltaAware)cacheEntry.getValue(), cacheEntry);
            ctx.putLookedUpEntry(deltaKey, deltaAwareEntry);
        } else {
            InternalCacheEntry ice = this.getFromContainer(deltaKey, false, false);
            DeltaAwareCacheEntry deltaEntry = this.createWrappedDeltaEntry(deltaKey, ice != null ? (DeltaAware)ice.getValue() : null, null);
            ctx.putLookedUpEntry(deltaKey, deltaEntry);
            deltaAwareEntry = deltaEntry;
        }
        if (trace) {
            log.tracef("Wrap %s for delta. Entry=%s", deltaKey, (Object)deltaAwareEntry);
        }
        return deltaAwareEntry;
    }

    private MVCCEntry assertRepeatableReadEntry(CacheEntry cacheEntry) {
        if (this.useRepeatableRead && !(cacheEntry instanceof RepeatableReadEntry)) {
            throw new IllegalStateException("Cache entry stored in context should be a RepeatableReadEntry instance but it is " + cacheEntry.getClass().getCanonicalName());
        }
        return (MVCCEntry)cacheEntry;
    }

    private CacheEntry getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (trace) {
            log.tracef("Exists in context? %s ", (Object)cacheEntry);
        }
        return cacheEntry;
    }

    private InternalCacheEntry getFromContainer(Object key, boolean ignoreOwnership, boolean writeOperation) {
        boolean isLocal;
        boolean bl = isLocal = this.distributionManager == null || this.distributionManager.getLocality(key).isLocal();
        if (isLocal || ignoreOwnership) {
            InternalCacheEntry ice = this.innerGetFromContainer(key, writeOperation);
            if (trace) {
                log.tracef("Retrieved from container %s (ignoreOwnership=%s, isLocal=%s)", (Object)ice, (Object)ignoreOwnership, (Object)isLocal);
            }
            return ice;
        }
        if (this.isL1Enabled) {
            boolean isL1Entry;
            InternalCacheEntry ice = this.innerGetFromContainer(key, writeOperation);
            boolean bl2 = isL1Entry = ice != null && ice.isL1Entry();
            if (trace) {
                log.tracef("Retrieved from container %s (L1 is enabled, isL1Entry=%s)", (Object)ice, (Object)isL1Entry);
            }
            return isL1Entry ? ice : null;
        }
        if (trace) {
            log.trace("Didn't retrieve from container.");
        }
        return null;
    }

    private InternalCacheEntry innerGetFromContainer(Object key, boolean writeOperation) {
        InternalCacheEntry ice;
        if (writeOperation) {
            ice = this.container.peek(key);
            if (ice != null && ice.canExpire()) {
                long wallClockTime = this.timeService.wallClockTime();
                if (ice.isExpired(wallClockTime)) {
                    ice = null;
                } else {
                    ice.touch(wallClockTime);
                }
            }
        } else {
            ice = this.container.get(key);
        }
        return ice;
    }

    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry, InvocationContext context, boolean skipRead) {
        ReadCommittedEntry mvccEntry;
        Object value = null;
        Metadata metadata = null;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            metadata = cacheEntry.getMetadata();
        }
        if (trace) {
            log.tracef("Creating new entry for key %s", (Object)Util.toStr(key));
        }
        ReadCommittedEntry readCommittedEntry = mvccEntry = this.useRepeatableRead ? new RepeatableReadEntry(key, value, metadata) : new ReadCommittedEntry(key, value, metadata);
        if (cacheEntry instanceof StateChangingEntry) {
            mvccEntry.copyStateFlagsFrom((StateChangingEntry)((Object)cacheEntry));
        }
        return mvccEntry;
    }

    private DeltaAwareCacheEntry createWrappedDeltaEntry(Object key, DeltaAware deltaAware, CacheEntry entry) {
        DeltaAwareCacheEntry<Object> deltaAwareCacheEntry = new DeltaAwareCacheEntry<Object>(key, deltaAware, entry);
        if (entry != null && entry.isCreated()) {
            deltaAwareCacheEntry.setCreated(true);
        }
        return deltaAwareCacheEntry;
    }
}

