/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;
import org.infinispan.commands.remote.recovery.RecoveryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.ByteString;

public class CompleteTransactionCommand
extends RecoveryCommand {
    public static final byte COMMAND_ID = 24;
    private Xid xid;
    private boolean commit;

    private CompleteTransactionCommand() {
        super(null);
    }

    public CompleteTransactionCommand(ByteString cacheName) {
        super(cacheName);
    }

    public CompleteTransactionCommand(ByteString cacheName, Xid xid, boolean commit) {
        super(cacheName);
        this.xid = xid;
        this.commit = commit;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        return this.recoveryManager.forceTransactionCompletion(this.xid, this.commit);
    }

    @Override
    public byte getCommandId() {
        return 24;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.xid);
        output.writeBoolean(this.commit);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.xid = (Xid)input.readObject();
        this.commit = input.readBoolean();
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", commit=" + this.commit + ", cacheName=" + this.cacheName + "} ";
    }
}

