/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.spi.DistributedTaskLifecycleService;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.ByteString;

public class DistributedExecuteCommand<V>
extends BaseRpcCommand
implements VisitableCommand,
CancellableCommand {
    public static final int COMMAND_ID = 19;
    private static final long serialVersionUID = -7828117401763700385L;
    private Cache<Object, Object> cache;
    private Set<Object> keys;
    private Callable<V> callable;
    private UUID uuid;

    public DistributedExecuteCommand(ByteString cacheName) {
        this(cacheName, null, null);
    }

    public DistributedExecuteCommand(ByteString cacheName, Collection<Object> inputKeys, Callable<V> callable) {
        super(cacheName);
        this.keys = inputKeys == null || inputKeys.isEmpty() ? Collections.emptySet() : new HashSet<Object>(inputKeys);
        this.callable = callable;
        this.uuid = UUID.randomUUID();
    }

    public DistributedExecuteCommand() {
        this(null, null, null);
    }

    public void init(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitDistributedExecuteCommand(ctx, this);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V perform(InvocationContext context) throws Exception {
        DistributedTaskLifecycleService taskLifecycleService = DistributedTaskLifecycleService.getInstance();
        Callable<V> callable = this.getCallable();
        V result = null;
        try {
            taskLifecycleService.onPreExecute(callable, this.cache);
            if (callable instanceof DistributedCallable) {
                DistributedCallable dc = (DistributedCallable)callable;
                dc.setEnvironment(this.cache, this.keys);
            }
            result = callable.call();
        }
        finally {
            taskLifecycleService.onPostExecute(callable);
        }
        return result;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public Set<Object> getKeys() {
        return this.keys;
    }

    public boolean hasKeys() {
        return this.keys.isEmpty();
    }

    @Override
    public byte getCommandId() {
        return 19;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, output);
        output.writeObject(this.callable);
        MarshallUtil.marshallUUID(this.uuid, output, false);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.callable = (Callable)input.readObject();
        this.uuid = MarshallUtil.unmarshallUUID(input, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributedExecuteCommand)) {
            return false;
        }
        DistributedExecuteCommand other = (DistributedExecuteCommand)obj;
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }

    @Override
    public String toString() {
        return "DistributedExecuteCommand [cache=" + this.cache + ", keys=" + this.keys + ", callable=" + this.callable + "]";
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

