/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PutKeyValueCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 8;
    Object value;
    boolean putIfAbsent;
    CacheNotifier notifier;
    boolean successful = true;
    Metadata metadata;
    private ValueMatcher valueMatcher;
    private Equivalence valueEquivalence;

    public PutKeyValueCommand() {
    }

    public PutKeyValueCommand(Object key, Object value, boolean putIfAbsent, CacheNotifier notifier, Metadata metadata, long flagsBitSet, Equivalence valueEquivalence, CommandInvocationId commandInvocationId) {
        super(key, flagsBitSet, commandInvocationId);
        this.value = value;
        this.putIfAbsent = putIfAbsent;
        this.valueMatcher = putIfAbsent ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
        this.notifier = notifier;
        this.metadata = metadata;
        this.valueEquivalence = valueEquivalence;
        if (value instanceof DeltaAware) {
            this.addFlag(Flag.DELTA_WRITE);
        }
    }

    public void init(CacheNotifier notifier, Configuration cfg) {
        this.notifier = notifier;
        this.valueEquivalence = cfg.dataContainer().valueEquivalence();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return this.putIfAbsent || !this.hasFlag(Flag.IGNORE_RETURN_VALUES);
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return this.hasFlag(Flag.DELTA_WRITE);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        Object entryValue = e.getValue();
        if (!this.valueMatcher.matches(e, null, this.value, this.valueEquivalence)) {
            this.successful = false;
            return entryValue;
        }
        return this.performPut(e, ctx);
    }

    @Override
    public byte getCommandId() {
        return 8;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.metadata);
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        output.writeObject(this.commandInvocationId);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.putIfAbsent);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.commandInvocationId = (CommandInvocationId)input.readObject();
        this.setFlagsBitSet(input.readLong());
        this.putIfAbsent = input.readBoolean();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public void setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        if (this.putIfAbsent != that.putIfAbsent) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.putIfAbsent ? 1 : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PutKeyValueCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", flags=" + this.printFlags() + ", putIfAbsent=" + this.putIfAbsent + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", metadata=" + this.metadata + ", successful=" + this.successful + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.putIfAbsent;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
        if (this.putIfAbsent) {
            this.successful = remoteResponse == null;
        }
    }

    private Object performPut(MVCCEntry e, InvocationContext ctx) {
        Object o;
        Object entryValue = e.getValue();
        if (e.isCreated()) {
            this.notifier.notifyCacheEntryCreated(this.key, this.value, this.metadata, true, ctx, this);
        } else {
            this.notifier.notifyCacheEntryModified(this.key, this.value, this.metadata, entryValue, e.getMetadata(), true, ctx, this);
        }
        if (this.value instanceof Delta) {
            Delta dv = (Delta)this.value;
            if (e.isRemoved()) {
                e.setExpired(false);
                e.setRemoved(false);
                e.setCreated(true);
                e.setValid(true);
                e.setValue(dv.merge(null));
                Metadatas.updateMetadata(e, this.metadata);
            } else {
                DeltaAware toMergeWith = null;
                if (entryValue instanceof CopyableDeltaAware) {
                    toMergeWith = ((CopyableDeltaAware)entryValue).copy();
                } else if (entryValue instanceof DeltaAware) {
                    toMergeWith = (DeltaAware)entryValue;
                }
                e.setValue(dv.merge(toMergeWith));
                Metadatas.updateMetadata(e, this.metadata);
            }
            o = entryValue;
        } else {
            o = e.setValue(this.value);
            Metadatas.updateMetadata(e, this.metadata);
            if (e.isRemoved()) {
                e.setCreated(true);
                e.setExpired(false);
                e.setRemoved(false);
                e.setValid(true);
                o = null;
            }
        }
        e.setChanged(true);
        return this.valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW ? o : null;
    }
}

