/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Map;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.topology.PersistentUUID;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.UUID;

public class JGroupsAddressCache {
    private static final EquivalentConcurrentHashMapV8<org.jgroups.Address, JGroupsAddress> addressCache = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
    private static final EquivalentConcurrentHashMapV8<JGroupsAddress, PersistentUUID> persistentUUIDCache = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());

    public static Address fromJGroupsAddress(Object address) {
        org.jgroups.Address jgAddress = (org.jgroups.Address)address;
        JGroupsAddress ispnAddress = addressCache.get(jgAddress);
        if (ispnAddress != null) {
            return ispnAddress;
        }
        return addressCache.computeIfAbsent(jgAddress, uuid -> {
            if (jgAddress instanceof ExtendedUUID) {
                return new JGroupsTopologyAwareAddress((ExtendedUUID)jgAddress);
            }
            return new JGroupsAddress(jgAddress);
        });
    }

    public static void putAddressPersistentUUID(Object address, PersistentUUID uuid) {
        persistentUUIDCache.put((JGroupsAddress)address, uuid);
    }

    public static PersistentUUID getPersistentUUID(Object address) {
        return persistentUUIDCache.get(address);
    }

    public static Address fromPersistentUUID(PersistentUUID uuid) {
        for (Map.Entry<JGroupsAddress, PersistentUUID> entry : persistentUUIDCache.entrySet()) {
            if (!entry.getValue().equals(uuid)) continue;
            return entry.getKey();
        }
        return null;
    }

    static void pruneAddressCache() {
        addressCache.forEachKey(Integer.MAX_VALUE, address -> {
            if (UUID.get(address) == null) {
                addressCache.remove(address);
                persistentUUIDCache.remove(address);
            }
        });
    }

    public static void flushAddressCaches() {
        addressCache.clear();
        persistentUUIDCache.clear();
    }
}

