/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.Option;
import com.squareup.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Service {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Option> options;
    private final List<Method> methods;

    public Service(String name, String fqname, String documentation, List<Option> options, List<Method> methods) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (methods == null) {
            throw new NullPointerException("methods");
        }
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        this.methods = Collections.unmodifiableList(new ArrayList<Method>(methods));
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Service)) {
            return false;
        }
        Service that = (Service)other;
        return this.name.equals(that.name) && this.fqname.equals(that.fqname) && this.documentation.equals(that.documentation) && this.options.equals(that.options) && this.methods.equals(that.methods);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fqname.hashCode();
        result = 31 * result + this.documentation.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.methods.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation);
        builder.append("service ").append(this.name).append(" {");
        if (!this.options.isEmpty()) {
            builder.append('\n');
            for (Option option : this.options) {
                Utils.appendIndented(builder, option.toDeclaration());
            }
        }
        if (!this.methods.isEmpty()) {
            builder.append('\n');
            for (Method method : this.methods) {
                Utils.appendIndented(builder, method.toString());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Method {
        private final String name;
        private final String documentation;
        private final String requestType;
        private final String responseType;
        private final List<Option> options;

        public Method(String name, String documentation, String requestType, String responseType, List<Option> options) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (requestType == null) {
                throw new NullPointerException("requestType");
            }
            if (responseType == null) {
                throw new NullPointerException("responseType");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.name = name;
            this.documentation = documentation;
            this.requestType = requestType;
            this.responseType = responseType;
            this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getRequestType() {
            return this.requestType;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method that = (Method)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.requestType.equals(that.requestType) && this.responseType.equals(that.responseType) && this.options.equals(that.options);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.documentation.hashCode();
            result = 31 * result + this.requestType.hashCode();
            result = 31 * result + this.responseType.hashCode();
            result = 31 * result + this.options.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Utils.appendDocumentation(builder, this.documentation);
            builder.append("rpc ").append(this.name).append(" (").append(this.requestType).append(") returns (").append(this.responseType).append(')');
            if (!this.options.isEmpty()) {
                builder.append(" {\n");
                for (Option option : this.options) {
                    Utils.appendIndented(builder, option.toDeclaration());
                }
                builder.append("}");
            }
            return builder.append(";\n").toString();
        }
    }
}

