/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.impl;

import infinispan.com.google.common.base.Preconditions;
import infinispan.com.google.common.cache.CacheBuilder;
import infinispan.com.google.common.cache.CacheLoader;
import infinispan.com.google.common.cache.LoadingCache;
import infinispan.com.google.common.cache.RemovalListener;
import infinispan.com.google.common.cache.RemovalNotification;
import infinispan.org.iq80.leveldb.impl.FileMetaData;
import infinispan.org.iq80.leveldb.impl.Filename;
import infinispan.org.iq80.leveldb.impl.Iq80DBFactory;
import infinispan.org.iq80.leveldb.table.FileChannelTable;
import infinispan.org.iq80.leveldb.table.MMapTable;
import infinispan.org.iq80.leveldb.table.Table;
import infinispan.org.iq80.leveldb.table.UserComparator;
import infinispan.org.iq80.leveldb.util.Closeables;
import infinispan.org.iq80.leveldb.util.Finalizer;
import infinispan.org.iq80.leveldb.util.InternalTableIterator;
import infinispan.org.iq80.leveldb.util.Slice;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutionException;

public class TableCache {
    private final LoadingCache<Long, TableAndFile> cache;
    private final Finalizer<Table> finalizer = new Finalizer(1);

    public TableCache(final File databaseDir, int tableCacheSize, final UserComparator userComparator, final boolean verifyChecksums) {
        Preconditions.checkNotNull(databaseDir, "databaseName is null");
        this.cache = CacheBuilder.newBuilder().maximumSize(tableCacheSize).removalListener(new RemovalListener<Long, TableAndFile>(){

            @Override
            public void onRemoval(RemovalNotification<Long, TableAndFile> notification) {
                Table table = notification.getValue().getTable();
                TableCache.this.finalizer.addCleanup(table, table.closer());
            }
        }).build(new CacheLoader<Long, TableAndFile>(){

            @Override
            public TableAndFile load(Long fileNumber) throws IOException {
                return new TableAndFile(databaseDir, fileNumber, userComparator, verifyChecksums);
            }
        });
    }

    public InternalTableIterator newIterator(FileMetaData file) {
        return this.newIterator(file.getNumber());
    }

    public InternalTableIterator newIterator(long number) {
        return new InternalTableIterator(this.getTable(number).iterator());
    }

    public long getApproximateOffsetOf(FileMetaData file, Slice key) {
        return this.getTable(file.getNumber()).getApproximateOffsetOf(key);
    }

    private Table getTable(long number) {
        Table table;
        try {
            table = this.cache.get(number).getTable();
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new RuntimeException("Could not open table " + number, cause);
        }
        return table;
    }

    public void close() {
        this.cache.invalidateAll();
        this.finalizer.destroy();
    }

    public void evict(long number) {
        this.cache.invalidate(number);
    }

    private static final class TableAndFile {
        private final Table table;
        private final FileChannel fileChannel;

        private TableAndFile(File databaseDir, long fileNumber, UserComparator userComparator, boolean verifyChecksums) throws IOException {
            String tableFileName = Filename.tableFileName(fileNumber);
            File tableFile = new File(databaseDir, tableFileName);
            this.fileChannel = new FileInputStream(tableFile).getChannel();
            try {
                this.table = Iq80DBFactory.USE_MMAP ? new MMapTable(tableFile.getAbsolutePath(), this.fileChannel, userComparator, verifyChecksums) : new FileChannelTable(tableFile.getAbsolutePath(), this.fileChannel, userComparator, verifyChecksums);
            }
            catch (IOException e) {
                Closeables.closeQuietly(this.fileChannel);
                throw e;
            }
        }

        public Table getTable() {
            return this.table;
        }
    }
}

