/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;

public class TransientMortalCacheValue
extends MortalCacheValue {
    protected long maxIdle = -1L;
    protected long lastUsed;

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle, long lastUsed) {
        this(value, created, lifespan, maxIdle);
        this.lastUsed = lastUsed;
    }

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle) {
        super(value, created, lifespan);
        this.maxIdle = maxIdle;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new TransientMortalCacheEntry(key, this.value, this.maxIdle, this.lifespan, this.lastUsed, this.created);
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientMortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheValue that = (TransientMortalCacheValue)o;
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "TransientMortalCacheValue{maxIdle=" + this.maxIdle + ", lastUsed=" + this.lastUsed + "} " + super.toString();
    }

    @Override
    public TransientMortalCacheValue clone() {
        return (TransientMortalCacheValue)super.clone();
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, TransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            UnsignedNumeric.writeUnsignedLong(output, value.created);
            output.writeLong(value.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, value.lastUsed);
            output.writeLong(value.maxIdle);
        }

        @Override
        public TransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheValue(v, created, lifespan, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 17;
        }

        @Override
        public Set<Class<? extends TransientMortalCacheValue>> getTypeClasses() {
            return Util.asSet(TransientMortalCacheValue.class);
        }
    }
}

