/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.remoting.ReplicationQueue;

public class AsyncConfiguration {
    public static final AttributeDefinition<ReplicationQueue> REPLICATION_QUEUE = AttributeDefinition.builder("replicationQueue", null, ReplicationQueue.class).immutable().build();
    public static final AttributeDefinition<Long> REPLICATION_QUEUE_INTERVAL = AttributeDefinition.builder("replicationQueueInterval", 10L).build();
    public static final AttributeDefinition<Integer> REPLICATION_QUEUE_MAX_ELEMENTS = AttributeDefinition.builder("replicationQueueMaxElements", 1000).build();
    public static final AttributeDefinition<Boolean> USE_REPLICATION_QUEUE = AttributeDefinition.builder("useReplicationQueue", false).immutable().build();
    private final Attribute<ReplicationQueue> replicationQueue;
    private final Attribute<Long> replicationQueueInterval;
    private final Attribute<Integer> replicationQueueMaxElements;
    private final Attribute<Boolean> useReplicationQueue;
    private AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AsyncConfiguration.class, REPLICATION_QUEUE, REPLICATION_QUEUE_INTERVAL, REPLICATION_QUEUE_MAX_ELEMENTS, USE_REPLICATION_QUEUE);
    }

    AsyncConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.replicationQueue = attributes.attribute(REPLICATION_QUEUE);
        this.replicationQueueInterval = attributes.attribute(REPLICATION_QUEUE_INTERVAL);
        this.replicationQueueMaxElements = attributes.attribute(REPLICATION_QUEUE_MAX_ELEMENTS);
        this.useReplicationQueue = attributes.attribute(USE_REPLICATION_QUEUE);
    }

    @Deprecated
    public boolean asyncMarshalling() {
        return false;
    }

    @Deprecated
    public ReplicationQueue replQueue() {
        return this.replicationQueue.get();
    }

    @Deprecated
    public long replQueueInterval() {
        return this.replicationQueueInterval.get();
    }

    @Deprecated
    public int replQueueMaxElements() {
        return this.replicationQueueMaxElements.get();
    }

    @Deprecated
    public boolean useReplQueue() {
        return this.useReplicationQueue.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncConfiguration other = (AsyncConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncConfiguration [attributes=" + this.attributes + "]";
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

