/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecUtils;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.Util;

public class Codec20
implements Codec,
HotRodConstants {
    private static final Log log = LogFactory.getLog(Codec20.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();
    final boolean trace = this.getLog().isTraceEnabled();

    @Override
    public <T> T readUnmarshallByteArray(Transport transport, short status, List<String> whitelist) {
        return CodecUtils.readUnmarshallByteArray(transport, status, whitelist);
    }

    @Override
    public void writeClientListenerInterests(Transport transport, Set<Class<? extends Annotation>> classes) {
    }

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)20);
    }

    @Override
    public void writeClientListenerParams(Transport transport, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        transport.writeByte((short)(clientListener.includeCurrentState() ? 1 : 0));
        this.writeNamedFactory(transport, clientListener.filterFactoryName(), filterFactoryParams);
        this.writeNamedFactory(transport, clientListener.converterFactoryName(), converterFactoryParams);
    }

    @Override
    public void writeExpirationParams(Transport transport, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (!CodecUtils.isIntCompatible(lifespan)) {
            log.warn("Lifespan value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        if (!CodecUtils.isIntCompatible(maxIdle)) {
            log.warn("MaxIdle value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        transport.writeVInt(lifespanSeconds);
        transport.writeVInt(maxIdleSeconds);
    }

    private void writeNamedFactory(Transport transport, String factoryName, byte[][] params) {
        transport.writeString(factoryName);
        if (!factoryName.isEmpty()) {
            if (params != null) {
                transport.writeByte((short)params.length);
                for (byte[] param : params) {
                    transport.writeArray(param);
                }
            } else {
                transport.writeByte((short)0);
            }
        }
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec20.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int joinedFlags = params.flags;
        transport.writeVInt(joinedFlags);
        transport.writeByte(params.clientIntel);
        int topologyId = params.topologyId.get();
        transport.writeVInt(topologyId);
        if (this.trace) {
            this.getLog().tracef("Wrote header for messageId=%d to %s. Operation code: %#04x. Flags: %#x. Topology id: %s", params.messageId, transport, params.opCode, joinedFlags, topologyId);
        }
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = this.readMagic(transport);
        long receivedMessageId = this.readMessageId(transport, params);
        short receivedOpCode = transport.readByte();
        return this.readPartialHeader(transport, params, receivedOpCode);
    }

    private short readPartialHeader(Transport transport, HeaderParams params, short receivedOpCode) {
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        if (this.trace) {
            this.getLog().tracef("Received operation code is: %#04x", receivedOpCode);
        }
        return status;
    }

    @Override
    public ClientEvent readEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller, List<String> whitelist) {
        this.readMagic(transport);
        this.readMessageId(transport, null);
        short eventTypeId = transport.readByte();
        return this.readPartialEvent(transport, expectedListenerId, marshaller, eventTypeId, whitelist);
    }

    protected ClientEvent readPartialEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller, short eventTypeId, List<String> whitelist) {
        boolean isRetried;
        ClientEvent.Type eventType;
        short status = transport.readByte();
        transport.readByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(transport, null, status);
            }
            default: {
                throw log.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = transport.readArray();
        if (!Arrays.equals(listenerId, expectedListenerId)) {
            throw log.unexpectedListenerId(Util.printArray(listenerId), Util.printArray(expectedListenerId));
        }
        short isCustom = transport.readByte();
        boolean bl = isRetried = transport.readByte() == 1;
        if (isCustom == 1) {
            Object eventData = MarshallerUtil.bytes2obj(marshaller, transport.readArray(), status, whitelist);
            return this.createCustomEvent(eventData, eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray(), status, whitelist);
                long createdDataVersion = transport.readLong();
                return this.createCreatedEvent(createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray(), status, whitelist);
                long modifiedDataVersion = transport.readLong();
                return this.createModifiedEvent(modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray(), status, whitelist);
                return this.createRemovedEvent(removedKey, isRetried);
            }
        }
        throw log.unknownEvent(eventTypeId);
    }

    @Override
    public Either<Short, ClientEvent> readHeaderOrEvent(Transport transport, HeaderParams params, byte[] expectedListenerId, Marshaller marshaller, List<String> whitelist) {
        this.readMagic(transport);
        this.readMessageId(transport, null);
        short opCode = transport.readByte();
        switch (opCode) {
            case 96: 
            case 97: 
            case 98: {
                ClientEvent clientEvent = this.readPartialEvent(transport, expectedListenerId, marshaller, opCode, whitelist);
                return Either.newRight(clientEvent);
            }
        }
        return Either.newLeft(this.readPartialHeader(transport, params, opCode));
    }

    @Override
    public Object returnPossiblePrevValue(Transport transport, short status, int flags, List<String> whitelist) {
        Marshaller marshaller = transport.getTransportFactory().getMarshaller();
        if (HotRodConstants.hasPrevious(status)) {
            byte[] bytes = transport.readArray();
            if (this.trace) {
                this.getLog().tracef("Previous value bytes is: %s", (Object)Util.printArray(bytes, false));
            }
            return bytes.length == 0 ? null : MarshallerUtil.bytes2obj(marshaller, bytes, status, whitelist);
        }
        return null;
    }

    protected ClientEvent createRemovedEvent(final Object key, final boolean isRetried) {
        return new ClientCacheEntryRemovedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryRemovedEvent(key=" + key + ")";
            }
        };
    }

    protected ClientCacheEntryModifiedEvent createModifiedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryModifiedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryModifiedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    protected ClientCacheEntryCreatedEvent<Object> createCreatedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryCreatedEvent<Object>(){

            @Override
            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCreatedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    protected ClientCacheEntryCustomEvent<Object> createCustomEvent(final Object eventData, final ClientEvent.Type eventType, final boolean isRetried) {
        return new ClientCacheEntryCustomEvent<Object>(){

            @Override
            public Object getEventData() {
                return eventData;
            }

            @Override
            public ClientEvent.Type getType() {
                return eventType;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCustomEvent(eventData=" + eventData + ", eventType=" + (Object)((Object)eventType) + ")";
            }
        };
    }

    private long readMessageId(Transport transport, HeaderParams params) {
        long receivedMessageId = transport.readVLong();
        Log localLog = this.getLog();
        if (params != null && receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", (Object)Util.hexDump(transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        if (this.trace) {
            localLog.tracef("Received response for messageId=%d", receivedMessageId);
        }
        return receivedMessageId;
    }

    private short readMagic(Transport transport) {
        short magic = transport.readByte();
        if (magic != 161) {
            Log localLog = this.getLog();
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", (Object)Util.hexDump(transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        return magic;
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        Log localLog = this.getLog();
        if (this.trace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = transport.readString();
                    if (status == 134 && this.trace) {
                        localLog.tracef("Server-side timeout performing operation: %s", (Object)msgFromServer);
                    } else {
                        localLog.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
                case 136: {
                    String msgFromServer = transport.readString();
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, params.messageId, status, transport.getRemoteSocketAddress());
                }
                case 135: {
                    String msgFromServer = transport.readString();
                    if (this.trace) {
                        localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, (Object)msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    transport.invalidate();
                }
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, HeaderParams params) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        int clusterSize = transport.readVInt();
        Object[] addresses = new SocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            addresses[i] = InetSocketAddress.createUnresolved(host, port);
        }
        short hashFunctionVersion = transport.readByte();
        int numSegments = transport.readVInt();
        SocketAddress[][] segmentOwners = new SocketAddress[numSegments][];
        if (hashFunctionVersion > 0) {
            for (int i = 0; i < numSegments; ++i) {
                int numOwners = transport.readByte();
                segmentOwners[i] = new SocketAddress[numOwners];
                for (int j = 0; j < numOwners; ++j) {
                    int memberIndex = transport.readVInt();
                    segmentOwners[i][j] = addresses[memberIndex];
                }
            }
        }
        TransportFactory transportFactory = transport.getTransportFactory();
        int currentTopology = transportFactory.getTopologyId(params.cacheName);
        int topologyAge = transportFactory.getTopologyAge();
        if (params.topologyAge == topologyAge && currentTopology != newTopologyId) {
            params.topologyId.set(newTopologyId);
            List<SocketAddress> addressList = Arrays.asList(addresses);
            if (localLog.isInfoEnabled()) {
                localLog.newTopology(transport.getRemoteSocketAddress(), newTopologyId, topologyAge, addresses.length, new HashSet<SocketAddress>(addressList));
            }
            transportFactory.updateServers(addressList, params.cacheName, false);
            if (hashFunctionVersion == 0) {
                if (this.trace) {
                    localLog.trace("Not using a consistent hash function (hash function version == 0).");
                }
            } else if (this.trace) {
                localLog.tracef("Updating client hash function with %s number of segments", numSegments);
            }
            transportFactory.updateHashFunction(segmentOwners, numSegments, hashFunctionVersion, params.cacheName, params.topologyId);
        } else if (this.trace) {
            log.tracef("Outdated topology received (topology id = %s, topology age = %s), so ignoring it: %s", newTopologyId, topologyAge, (Object)Arrays.toString(addresses));
        }
    }
}

