/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.util.CloseableSupplier;

public class CloseableSuppliedIterator<E>
implements CloseableIterator<E> {
    private final CloseableSupplier<? extends E> supplier;
    private E next;

    public CloseableSuppliedIterator(CloseableSupplier<? extends E> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        this.supplier = supplier;
    }

    @Override
    public void close() {
        this.supplier.close();
    }

    private E getNext() {
        return (E)this.supplier.get();
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.getNext();
        }
        return this.next != null;
    }

    @Override
    public E next() {
        E e;
        E e2 = e = this.next == null ? this.getNext() : this.next;
        if (e == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        return e;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Object supplied;
        if (this.next != null) {
            action.accept(this.next);
        }
        while ((supplied = this.supplier.get()) != null) {
            action.accept(supplied);
        }
    }
}

