/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DeadlockDetectingInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(DeadlockDetectingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    public void start() {
        if (!this.cacheConfiguration.deadlockDetection().enabled()) {
            throw new IllegalStateException("This interceptor should not be present in the chain as deadlock detection is not used!");
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getKeys());
            CacheMode cacheMode = this.cacheConfiguration.clustering().cacheMode();
            if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
                if (trace) {
                    log.tracef("Locks as seen at origin are: %s", (Object)ctx.getLockedKeys());
                }
                ((DldGlobalTransaction)ctx.getGlobalTransaction()).setLocksHeldAtOrigin(ctx.getLockedKeys());
            }
        }
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getAffectedKeys());
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(InfinispanCollections.emptySet());
        }
        return result;
    }

    private Object handleDataCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }
}

