/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.marshall.core.CacheMarshaller;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.marshall.core.VersionAwareMarshaller;

@DefaultFactoryFor(classes={StreamingMarshaller.class, Marshaller.class})
public class MarshallerFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        Marshaller comp;
        Marshaller configMarshaller = this.globalConfiguration.serialization().marshaller();
        boolean isVersionAwareMarshaller = configMarshaller instanceof VersionAwareMarshaller;
        if (isVersionAwareMarshaller) {
            if (componentName.equals("org.infinispan.marshaller.global")) {
                comp = new GlobalMarshaller((VersionAwareMarshaller)configMarshaller);
            } else {
                if (!componentName.equals("org.infinispan.marshaller.cache")) throw new CacheException("Don't know how to handle type " + componentType);
                comp = new CacheMarshaller(new VersionAwareMarshaller());
            }
        } else {
            comp = configMarshaller;
        }
        try {
            return componentType.cast(comp);
        }
        catch (Exception e) {
            throw new CacheException("Problems casting bootstrap component " + comp.getClass() + " to type " + componentType, e);
        }
    }
}

