/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.transaction.totalorder.TotalOrderLatch;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderRemoteTransactionState {
    private static final Log log = LogFactory.getLog(TotalOrderRemoteTransactionState.class);
    private static final boolean trace = log.isTraceEnabled();
    private final EnumSet<State> transactionState = EnumSet.noneOf(State.class);
    private final GlobalTransaction globalTransaction;
    private List<Object> lockedKeys;
    private TotalOrderLatch block;
    private List<TotalOrderLatch> dependencies;

    public TotalOrderRemoteTransactionState(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public synchronized boolean isRollbackReceived() {
        return this.transactionState.contains((Object)State.ROLLBACK_ONLY);
    }

    public synchronized boolean isCommitReceived() {
        return this.transactionState.contains((Object)State.COMMIT_ONLY);
    }

    public synchronized void prepared() {
        if (trace) {
            log.tracef("[%s] Current status is %s, setting status to: PREPARED", (Object)this.globalTransaction.globalId(), (Object)this.transactionState);
        }
        this.transactionState.add(State.PREPARED);
        this.notifyAll();
    }

    public synchronized void preparing() {
        if (trace) {
            log.tracef("[%s] Current status is %s, setting status to: PREPARING", (Object)this.globalTransaction.globalId(), (Object)this.transactionState);
        }
        this.transactionState.add(State.PREPARING);
    }

    public final synchronized boolean waitUntilPrepared(boolean commit) throws InterruptedException {
        boolean result;
        State state;
        State state2 = state = commit ? State.COMMIT_ONLY : State.ROLLBACK_ONLY;
        if (trace) {
            log.tracef("[%s] Current status is %s, setting status to: %s", (Object)this.globalTransaction.globalId(), (Object)this.transactionState, (Object)state);
        }
        this.transactionState.add(state);
        if (this.transactionState.contains((Object)State.PREPARED)) {
            result = true;
            if (trace) {
                log.tracef("[%s] Transaction is PREPARED", (Object)this.globalTransaction.globalId());
            }
        } else if (this.transactionState.contains((Object)State.PREPARING)) {
            this.wait();
            result = true;
            if (trace) {
                log.tracef("[%s] Transaction was in PREPARING state but now it is prepared", (Object)this.globalTransaction.globalId());
            }
        } else {
            if (trace) {
                log.tracef("[%s] Transaction is not delivered yet", (Object)this.globalTransaction.globalId());
            }
            result = false;
        }
        return result;
    }

    public final synchronized boolean isFinished() {
        return this.transactionState.contains((Object)State.PREPARED) && (this.transactionState.contains((Object)State.COMMIT_ONLY) || this.transactionState.contains((Object)State.ROLLBACK_ONLY));
    }

    public final synchronized Collection<Object> getLockedKeys() {
        return this.lockedKeys;
    }

    public final synchronized TotalOrderLatch getTransactionSynchronizedBlock() {
        return this.block;
    }

    public final synchronized void setTransactionSynchronizedBlock(TotalOrderLatch block) {
        this.block = block;
    }

    public final synchronized GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public final synchronized void awaitUntilReset() throws InterruptedException {
        while (this.block != null && this.lockedKeys != null) {
            this.wait();
        }
    }

    public final synchronized void reset() {
        this.block = null;
        this.lockedKeys = null;
        this.notifyAll();
    }

    public String toString() {
        return "TotalOrderRemoteTransactionState{transactionState=" + this.transactionState + ", globalTransaction='" + this.globalTransaction.globalId() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TotalOrderRemoteTransactionState state = (TotalOrderRemoteTransactionState)o;
        return !(this.globalTransaction == null ? state.globalTransaction != null : !this.globalTransaction.equals(state.globalTransaction));
    }

    public int hashCode() {
        return this.globalTransaction != null ? this.globalTransaction.hashCode() : 0;
    }

    public final synchronized void addSynchronizedBlock(TotalOrderLatch block) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<TotalOrderLatch>(8);
        }
        this.dependencies.add(block);
    }

    public final synchronized void addAllSynchronizedBlocks(Collection<TotalOrderLatch> blocks) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<TotalOrderLatch>(blocks);
        } else {
            this.dependencies.addAll(blocks);
        }
    }

    public final synchronized void addKeysLockedForClear() {
        this.lockedKeys = null;
    }

    public final synchronized void addLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new ArrayList<Object>(8);
        }
        this.lockedKeys.add(key);
    }

    public synchronized Collection<TotalOrderLatch> getConflictingTransactionBlocks() {
        return this.dependencies == null ? InfinispanCollections.emptyList() : this.dependencies;
    }

    private static enum State {
        PREPARING,
        PREPARED,
        ROLLBACK_ONLY,
        COMMIT_ONLY;

    }
}

