/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.jgroups.CustomRequestCorrelator;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.RspListFuture;
import org.infinispan.remoting.transport.jgroups.SingleResponseFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.UpHandler;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    public static final RspList<Response> EMPTY_RESPONSES_LIST = new RspList();
    private static final Log log = LogFactory.getLog(LogWrapper.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean FORCE_MCAST = Boolean.getBoolean("infinispan.unsafe.force_multicast");
    private final InboundInvocationHandler handler;
    private final ScheduledExecutorService timeoutExecutor;

    public CommandAwareRpcDispatcher(Channel channel, JGroupsTransport transport, InboundInvocationHandler globalHandler, ScheduledExecutorService timeoutExecutor) {
        this.server_obj = transport;
        this.handler = globalHandler;
        this.timeoutExecutor = timeoutExecutor;
        this.setMembershipListener(transport);
        this.setChannel(channel);
        UpHandler handler = channel.getUpHandler();
        if (handler instanceof Muxer) {
            Muxer mux = (Muxer)((Object)handler);
            mux.setDefaultHandler(this.prot_adapter);
        }
        channel.addChannelListener(this);
        this.asyncDispatching(true);
    }

    @Override
    public void close() {
        this.stop();
        this.channel.removeChannelListener(this);
    }

    @Override
    protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        return new CustomRequestCorrelator(transport, handler, local_addr);
    }

    private boolean isValid(Message req) {
        if (req == null || req.getLength() == 0) {
            log.msgOrMsgBufferEmpty();
            return false;
        }
        return true;
    }

    public RspListFuture invokeRemoteCommands(List<Address> recipients, ReplicableCommand command, ResponseMode mode, long timeout, RspFilter filter, DeliverOrder deliverOrder) {
        try {
            RspListFuture future = this.processCalls(command, recipients == null, timeout, filter, recipients, mode, deliverOrder, this.req_marshaller);
            return future;
        }
        catch (Exception e) {
            return (RspListFuture)this.rethrowAsCacheException(e);
        }
    }

    public SingleResponseFuture invokeRemoteCommand(Address recipient, ReplicableCommand command, ResponseMode mode, long timeout, DeliverOrder deliverOrder) {
        try {
            SingleResponseFuture future = this.processSingleCall(command, timeout, recipient, mode, deliverOrder, this.req_marshaller);
            return future;
        }
        catch (Exception e) {
            return (SingleResponseFuture)this.rethrowAsCacheException(e);
        }
    }

    public <T> T rethrowAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        throw new CacheException(t);
    }

    @Override
    public void handle(Message req, org.jgroups.blocks.Response response) throws Exception {
        block11: {
            if (this.isValid(req)) {
                ReplicableCommand cmd = null;
                try {
                    cmd = (ReplicableCommand)this.req_marshaller.objectFromBuffer(req.getRawBuffer(), req.getOffset(), req.getLength());
                    if (cmd == null) {
                        throw new NullPointerException("Unable to execute a null command!  Message was " + req);
                    }
                    if (req.getSrc() instanceof SiteAddress) {
                        this.executeCommandFromRemoteSite(cmd, req, response);
                        break block11;
                    }
                    this.executeCommandFromLocalCluster(cmd, req, response);
                }
                catch (InterruptedException e) {
                    log.shutdownHandlingCommand(cmd);
                    this.reply(response, new ExceptionResponse(new CacheException("Cache is shutting down")), cmd);
                }
                catch (IllegalLifecycleStateException e) {
                    if (trace) {
                        log.trace("Ignoring command unmarshalling error during shutdown");
                    }
                    this.reply(response, CacheNotFoundResponse.INSTANCE, cmd);
                }
                catch (Throwable x) {
                    if (cmd == null) {
                        log.errorUnMarshallingCommand(x);
                    } else {
                        log.exceptionHandlingCommand(cmd, x);
                    }
                    this.reply(response, new ExceptionResponse(new CacheException("Problems invoking command.", x)), cmd);
                }
            } else {
                this.reply(response, null, null);
            }
        }
    }

    private void executeCommandFromRemoteSite(ReplicableCommand cmd, Message req, org.jgroups.blocks.Response response) throws Throwable {
        SiteAddress siteAddress = (SiteAddress)req.getSrc();
        ((XSiteReplicateCommand)cmd).setOriginSite(siteAddress.getSite());
        Reply reply = returnValue -> this.reply(response, returnValue, cmd);
        this.handler.handleFromRemoteSite(siteAddress.getSite(), (XSiteReplicateCommand)cmd, reply, CommandAwareRpcDispatcher.decodeDeliverMode(req));
    }

    private void executeCommandFromLocalCluster(ReplicableCommand cmd, Message req, org.jgroups.blocks.Response response) throws Throwable {
        Reply reply = returnValue -> this.reply(response, returnValue, cmd);
        this.handler.handleFromCluster(JGroupsTransport.fromJGroupsAddress(req.getSrc()), cmd, reply, CommandAwareRpcDispatcher.decodeDeliverMode(req));
    }

    private static DeliverOrder decodeDeliverMode(Message request) {
        boolean noTotalOrder = request.isFlagSet(Message.Flag.NO_TOTAL_ORDER);
        boolean oob = request.isFlagSet(Message.Flag.OOB);
        if (!noTotalOrder && oob) {
            return DeliverOrder.TOTAL;
        }
        if (noTotalOrder && oob) {
            return DeliverOrder.NONE;
        }
        if (noTotalOrder) {
            return DeliverOrder.PER_SENDER;
        }
        throw new IllegalArgumentException("Unable to decode message " + request);
    }

    private static void encodeDeliverMode(Message request, DeliverOrder deliverOrder) {
        switch (deliverOrder) {
            case TOTAL: {
                request.setFlag(Message.Flag.OOB.value());
                break;
            }
            case PER_SENDER: {
                request.setFlag(Message.Flag.NO_TOTAL_ORDER.value());
                break;
            }
            case NONE: {
                request.setFlag((short)(Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value()));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    private void reply(org.jgroups.blocks.Response response, Object retVal, ReplicableCommand command) {
        if (response != null) {
            if (trace) {
                log.tracef("About to send back response %s for command %s", retVal, (Object)command);
            }
            response.send(retVal, false);
        }
    }

    protected static Message constructMessage(Buffer buf, Address recipient, ResponseMode mode, boolean rsvp, DeliverOrder deliverOrder) {
        Message msg = new Message();
        msg.setBuffer(buf);
        CommandAwareRpcDispatcher.encodeDeliverMode(msg, deliverOrder);
        if (deliverOrder == DeliverOrder.NONE || mode != ResponseMode.GET_NONE) {
            msg.setFlag(Message.Flag.DONT_BUNDLE.value());
        }
        if (deliverOrder != DeliverOrder.TOTAL) {
            msg.setTransientFlag(Message.TransientFlag.DONT_LOOPBACK.value());
        }
        if (rsvp) {
            msg.setFlag(Message.Flag.RSVP.value());
        }
        if (recipient != null) {
            msg.setDest(recipient);
        }
        return msg;
    }

    Buffer marshallCall(RpcDispatcher.Marshaller marshaller, ReplicableCommand command) {
        Buffer buf;
        try {
            buf = marshaller.objectToBuffer(command);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
        return buf;
    }

    private SingleResponseFuture processSingleCall(ReplicableCommand command, long timeout, Address destination, ResponseMode mode, DeliverOrder deliverOrder, RpcDispatcher.Marshaller marshaller) throws Exception {
        if (trace) {
            log.tracef("Replication task sending %s to single recipient %s with response mode %s", (Object)command, (Object)destination, (Object)mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        Buffer buf = this.marshallCall(marshaller, command);
        Message msg = CommandAwareRpcDispatcher.constructMessage(buf, destination, mode, rsvp, deliverOrder);
        NotifyingFuture<Response> request = this.sendMessageWithFuture(msg, new RequestOptions(mode, timeout));
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        SingleResponseFuture retval = new SingleResponseFuture(request);
        if (timeout > 0L && !retval.isDone()) {
            ScheduledFuture<Void> timeoutFuture = this.timeoutExecutor.schedule(retval, timeout, TimeUnit.MILLISECONDS);
            retval.setTimeoutFuture(timeoutFuture);
        }
        return retval;
    }

    private RspListFuture processCalls(ReplicableCommand command, boolean broadcast, long timeout, RspFilter filter, List<Address> dests, ResponseMode mode, DeliverOrder deliverOrder, RpcDispatcher.Marshaller marshaller) throws Exception {
        RequestOptions opts;
        Message msg;
        if (trace) {
            log.tracef("Replication task sending %s to addresses %s with response mode %s", (Object)command, (Object)dests, (Object)mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        Buffer buf = this.marshallCall(marshaller, command);
        if (deliverOrder == DeliverOrder.TOTAL) {
            msg = CommandAwareRpcDispatcher.constructMessage(buf, new AnycastAddress(dests), mode, rsvp, deliverOrder);
            opts = new RequestOptions(mode, timeout, false, filter);
        } else if (broadcast || FORCE_MCAST) {
            msg = CommandAwareRpcDispatcher.constructMessage(buf, null, mode, rsvp, deliverOrder);
            opts = new RequestOptions(mode, timeout, false, filter);
        } else {
            msg = CommandAwareRpcDispatcher.constructMessage(buf, null, mode, rsvp, deliverOrder);
            opts = new RequestOptions(mode, timeout, true, filter);
        }
        GroupRequest<Response> request = this.cast(dests, msg, opts, false);
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        RspListFuture retval = new RspListFuture(request);
        if (request == null) {
            if (broadcast) {
                retval.complete(EMPTY_RESPONSES_LIST);
            } else {
                ArrayList rsps = new ArrayList(dests.size());
                for (Address dest : dests) {
                    Rsp rsp = new Rsp(dest);
                    rsp.setSuspected();
                    rsps.add(rsp);
                }
                retval.complete(new RspList(rsps));
            }
        }
        if (timeout > 0L && !retval.isDone()) {
            ScheduledFuture<Void> timeoutFuture = this.timeoutExecutor.schedule(retval, timeout, TimeUnit.MILLISECONDS);
            retval.setTimeoutFuture(timeoutFuture);
        }
        return retval;
    }

    private static boolean isRsvpCommand(ReplicableCommand command) {
        return command instanceof FlagAffectedCommand && ((FlagAffectedCommand)command).hasFlag(Flag.GUARANTEED_DELIVERY);
    }

    static class LogWrapper {
        LogWrapper() {
        }
    }
}

