/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.impl.AuthorizationHelper;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private AuthorizationConfiguration configuration;
    private AuthorizationHelper authzHelper;

    @Inject
    public void init(Cache<?, ?> cache, GlobalConfiguration globalConfiguration, Configuration configuration, GlobalSecurityManager globalSecurityManager) {
        this.configuration = configuration.security().authorization();
        this.authzHelper = new AuthorizationHelper(globalConfiguration.security(), AuditContext.CACHE, cache.getName(), globalSecurityManager.globalACLCache());
    }

    @Override
    public void checkPermission(AuthorizationPermission perm) {
        this.authzHelper.checkPermission(this.configuration, perm, null);
    }

    @Override
    public void checkPermission(AuthorizationPermission perm, String role) {
        this.authzHelper.checkPermission(this.configuration, perm, role);
    }
}

