/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.stream.impl.RemovableCloseableIterator;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeyStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<K> {
    private static final Log log = LogFactory.getLog(KeyStreamSupplier.class);
    private final Cache<K, V> cache;
    private final ConsistentHash hash;
    private final Supplier<Stream<K>> supplier;

    public KeyStreamSupplier(Cache<K, V> cache, ConsistentHash hash, Supplier<Stream<K>> supplier) {
        this.cache = cache;
        this.hash = hash;
        this.supplier = supplier;
    }

    @Override
    public Stream<K> buildStream(Set<Integer> segmentsToFilter, Set<?> keysToFilter) {
        Stream<Object> stream;
        if (keysToFilter != null) {
            log.tracef("Applying key filtering %s", (Object)keysToFilter);
            stream = keysToFilter.stream().filter(k -> this.cache.containsKey(k));
        } else {
            stream = this.supplier.get();
        }
        if (segmentsToFilter != null && this.hash != null) {
            log.tracef("Applying segment filter %s", (Object)segmentsToFilter);
            stream = stream.filter(k -> segmentsToFilter.contains(this.hash.getSegment(k)));
        }
        return stream;
    }

    @Override
    public CloseableIterator<K> removableIterator(CloseableIterator<K> realIterator) {
        return new RemovableCloseableIterator<K, K>(realIterator, this.cache, Function.identity());
    }
}

