/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.impl;

import infinispan.com.google.common.base.Preconditions;
import infinispan.com.google.common.collect.Lists;
import infinispan.com.google.common.collect.Maps;
import infinispan.org.iq80.leveldb.WriteBatch;
import infinispan.org.iq80.leveldb.util.Slice;
import infinispan.org.iq80.leveldb.util.Slices;
import java.util.List;
import java.util.Map;

public class WriteBatchImpl
implements WriteBatch {
    private List<Map.Entry<Slice, Slice>> batch = Lists.newArrayList();
    private int approximateSize;

    public int getApproximateSize() {
        return this.approximateSize;
    }

    public int size() {
        return this.batch.size();
    }

    @Override
    public WriteBatchImpl put(byte[] key, byte[] value) {
        Preconditions.checkNotNull(key, "key is null");
        Preconditions.checkNotNull(value, "value is null");
        this.batch.add(Maps.immutableEntry(Slices.wrappedBuffer(key), Slices.wrappedBuffer(value)));
        this.approximateSize += 12 + key.length + value.length;
        return this;
    }

    public WriteBatchImpl put(Slice key, Slice value) {
        Preconditions.checkNotNull(key, "key is null");
        Preconditions.checkNotNull(value, "value is null");
        this.batch.add(Maps.immutableEntry(key, value));
        this.approximateSize += 12 + key.length() + value.length();
        return this;
    }

    @Override
    public WriteBatchImpl delete(byte[] key) {
        Preconditions.checkNotNull(key, "key is null");
        this.batch.add(Maps.immutableEntry(Slices.wrappedBuffer(key), null));
        this.approximateSize += 6 + key.length;
        return this;
    }

    public WriteBatchImpl delete(Slice key) {
        Preconditions.checkNotNull(key, "key is null");
        this.batch.add(Maps.immutableEntry(key, null));
        this.approximateSize += 6 + key.length();
        return this;
    }

    @Override
    public void close() {
    }

    public void forEach(Handler handler) {
        for (Map.Entry<Slice, Slice> entry : this.batch) {
            Slice key = entry.getKey();
            Slice value = entry.getValue();
            if (value != null) {
                handler.put(key, value);
                continue;
            }
            handler.delete(key);
        }
    }

    public static interface Handler {
        public void put(Slice var1, Slice var2);

        public void delete(Slice var1);
    }
}

