/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.auth.sasl.SaslContext;
import org.jgroups.protocols.SASL;
import org.jgroups.protocols.SaslHeader;

public class SaslServerContext
implements SaslContext {
    SaslServer server;
    CountDownLatch latch = new CountDownLatch(1);
    Subject subject;

    public SaslServerContext(final SaslServerFactory saslServerFactory, final String mech, final String serverName, final CallbackHandler callback_handler, final Map<String, String> props, Subject subject) throws SaslException {
        this.subject = subject;
        if (this.subject != null) {
            try {
                this.server = Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslServer>(){

                    @Override
                    public SaslServer run() throws Exception {
                        return saslServerFactory.createSaslServer(mech, "jgroups", serverName, props, callback_handler);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SaslException)e.getCause();
            }
        } else {
            this.server = saslServerFactory.createSaslServer(mech, "jgroups", serverName, props, callback_handler);
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.server.isComplete();
    }

    @Override
    public boolean needsWrapping() {
        if (this.server.isComplete()) {
            String qop = (String)this.server.getNegotiatedProperty("javax.security.sasl.qop");
            return qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"));
        }
        return false;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.server.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.server.unwrap(incoming, offset, len);
    }

    @Override
    public Message nextMessage(Address address, SaslHeader header) throws SaslException {
        Message message = new Message(address).setFlag(Message.Flag.OOB);
        byte[] challenge = this.server.evaluateResponse(header.getPayload());
        if (this.server.isComplete()) {
            this.latch.countDown();
        }
        if (challenge != null) {
            return message.putHeader(SASL.SASL_ID, new SaslHeader(SaslHeader.Type.CHALLENGE, challenge));
        }
        return null;
    }

    public void awaitCompletion(long timeout) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public String getAuthorizationID() {
        return this.server.getAuthorizationID();
    }

    @Override
    public void dispose() {
        try {
            this.server.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }
}

