/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.synchronization;

import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.impl.AbstractEnlistmentAdapter;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SynchronizationAdapter
extends AbstractEnlistmentAdapter
implements Synchronization {
    private static final Log log = LogFactory.getLog(SynchronizationAdapter.class);
    private final LocalTransaction localTransaction;

    public SynchronizationAdapter(LocalTransaction localTransaction, TransactionCoordinator txCoordinator, CommandsFactory commandsFactory, RpcManager rpcManager, TransactionTable transactionTable, ClusteringDependentLogic clusteringLogic, Configuration configuration, PartitionHandlingManager partitionHandlingManager) {
        super(localTransaction, commandsFactory, rpcManager, transactionTable, clusteringLogic, configuration, txCoordinator, partitionHandlingManager);
        this.localTransaction = localTransaction;
    }

    public void beforeCompletion() {
        log.tracef("beforeCompletion called for %s", (Object)this.localTransaction);
        try {
            this.txCoordinator.prepare(this.localTransaction);
        }
        catch (XAException e) {
            throw new CacheException("Could not prepare. ", e);
        }
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.tracef("afterCompletion(%s) called for %s.", status, (Object)this.localTransaction);
        }
        if (status == 3) {
            boolean isOnePhase;
            try {
                isOnePhase = this.txCoordinator.commit(this.localTransaction, false);
            }
            catch (XAException e) {
                throw new CacheException("Could not commit.", e);
            }
            this.releaseLocksForCompletedTransaction(this.localTransaction, isOnePhase);
        } else if (status == 4) {
            try {
                this.txCoordinator.rollback(this.localTransaction);
            }
            catch (XAException e) {
                throw new CacheException("Could not commit.", e);
            }
        } else {
            throw new IllegalArgumentException("Unknown status: " + status);
        }
    }

    public String toString() {
        return "SynchronizationAdapter{localTransaction=" + this.localTransaction + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizationAdapter that = (SynchronizationAdapter)o;
        return !(this.localTransaction != null ? !this.localTransaction.equals(that.localTransaction) : that.localTransaction != null);
    }
}

