/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.keymappers.Key2StringMapper;

public class JdbcMixedStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcMixedStoreConfiguration, JdbcMixedStoreConfigurationBuilder>
implements JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> {
    private final MixedTableManipulationConfigurationBuilder binaryTable = new MixedTableManipulationConfigurationBuilder(this);
    private final MixedTableManipulationConfigurationBuilder stringTable = new MixedTableManipulationConfigurationBuilder(this);

    public JdbcMixedStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, JdbcMixedStoreConfiguration.attributeDefinitionSet());
    }

    @Override
    public JdbcMixedStoreConfigurationBuilder self() {
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder batchSize(int batchSize) {
        this.attributes.attribute(JdbcMixedStoreConfiguration.BATCH_SIZE).set(batchSize);
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder fetchSize(int fetchSize) {
        this.attributes.attribute(JdbcMixedStoreConfiguration.FETCH_SIZE).set(fetchSize);
        return this;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder binaryTable() {
        return this.binaryTable;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder stringTable() {
        return this.stringTable;
    }

    @Override
    public JdbcMixedStoreConfigurationBuilder withProperties(Properties props) {
        Map<Object, Object> unrecognized = XmlConfigHelper.setAttributes(this.attributes, props, false, false);
        XmlConfigHelper.setAttributes(this.binaryTable.attributes(), unrecognized, false, false);
        unrecognized = XmlConfigHelper.setAttributes(this.stringTable.attributes(), unrecognized, false, false);
        XmlConfigHelper.showUnrecognizedAttributes(unrecognized);
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return this;
    }

    @Override
    public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
        this.attributes.attribute(JdbcMixedStoreConfiguration.KEY2STRING_MAPPER).set(key2StringMapper);
        return this;
    }

    @Override
    public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
        this.key2StringMapper(klass.getName());
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.binaryTable.tableNamePrefix().equals(this.stringTable.tableNamePrefix())) {
            throw new CacheConfigurationException("There cannot be the same tableNamePrefix on both the binary and String tables.");
        }
    }

    public JdbcMixedStoreConfigurationBuilder lockConcurrencyLevel(int l) {
        this.attributes.attribute(JdbcMixedStoreConfiguration.CONCURRENCY_LEVEL).set(l);
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder lockAcquisitionTimeout(long timeout) {
        this.attributes.attribute(JdbcMixedStoreConfiguration.LOCK_ACQUISITION_TIMEOUT).set(timeout);
        return this;
    }

    @Override
    public JdbcMixedStoreConfiguration create() {
        return new JdbcMixedStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), (ConnectionFactoryConfiguration)this.connectionFactory.create(), this.binaryTable.create(), this.stringTable.create());
    }

    public JdbcMixedStoreConfigurationBuilder read(JdbcMixedStoreConfiguration template) {
        super.read(template);
        this.binaryTable.read(template.binaryTable());
        this.stringTable.read(template.stringTable());
        return this;
    }

    @Override
    public String toString() {
        return "JdbcMixedStoreConfigurationBuilder [binaryTable=" + this.binaryTable + ", stringTable=" + this.stringTable + ", connectionFactory=" + this.connectionFactory + ", attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }

    public class MixedTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcMixedStoreConfigurationBuilder, MixedTableManipulationConfigurationBuilder>
    implements JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> {
        MixedTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcMixedStoreConfigurationBuilder> builder) {
            super(builder);
        }

        @Override
        public MixedTableManipulationConfigurationBuilder self() {
            return this;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder binaryTable() {
            return JdbcMixedStoreConfigurationBuilder.this.binaryTable;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder stringTable() {
            return JdbcMixedStoreConfigurationBuilder.this.stringTable;
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcMixedStoreConfigurationBuilder> connectionPool() {
            return JdbcMixedStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcMixedStoreConfigurationBuilder> dataSource() {
            return JdbcMixedStoreConfigurationBuilder.this.dataSource();
        }

        @Override
        public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
            return JdbcMixedStoreConfigurationBuilder.this.key2StringMapper(key2StringMapper);
        }

        @Override
        public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
            return JdbcMixedStoreConfigurationBuilder.this.key2StringMapper(klass);
        }
    }
}

