/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.TypeLiteral;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cdi.AdvancedCacheProducer;
import org.infinispan.cdi.ConfigureCache;
import org.infinispan.cdi.ContextInputCache;
import org.infinispan.cdi.InputLiteral;
import org.infinispan.cdi.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.cdi.util.BeanBuilder;
import org.infinispan.cdi.util.Beans;
import org.infinispan.cdi.util.ContextualLifecycle;
import org.infinispan.cdi.util.ContextualReference;
import org.infinispan.cdi.util.DefaultLiteral;
import org.infinispan.cdi.util.Reflections;
import org.infinispan.cdi.util.defaultbean.DefaultBean;
import org.infinispan.cdi.util.defaultbean.DefaultBeanHolder;
import org.infinispan.cdi.util.defaultbean.Installed;
import org.infinispan.cdi.util.logging.EmbeddedLog;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanExtensionEmbedded
implements Extension {
    private static final EmbeddedLog logger = LogFactory.getLog(InfinispanExtensionEmbedded.class, EmbeddedLog.class);
    private final Set<ConfigurationHolder> configurations;
    private volatile boolean registered = false;
    private final Object registerLock = new Object();
    private Set<Set<Annotation>> installedEmbeddedCacheManagers = new HashSet<Set<Annotation>>();

    public InfinispanExtensionEmbedded() {
        new ConfigurationBuilder();
        this.configurations = new HashSet<ConfigurationHolder>();
    }

    void processProducers(@Observes ProcessProducer<?, ?> event, BeanManager beanManager) {
        ConfigureCache annotation = (ConfigureCache)event.getAnnotatedMember().getAnnotation(ConfigureCache.class);
        if (annotation != null) {
            this.configurations.add(new ConfigurationHolder((Producer<Configuration>)event.getProducer(), annotation.value(), Reflections.getQualifiers(beanManager, (Iterable<Annotation>)event.getAnnotatedMember().getAnnotations())));
        }
    }

    <T, X> void registerCacheBeans(@Observes AfterBeanDiscovery event, final BeanManager beanManager) {
        for (final ConfigurationHolder holder : this.configurations) {
            Bean b = new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(AdvancedCache.class)).qualifiers(Beans.buildQualifiers(holder.getQualifiers())).addType(new TypeLiteral<AdvancedCache<T, X>>(){}.getType()).addType(new TypeLiteral<Cache<T, X>>(){}.getType()).beanLifecycle(new ContextualLifecycle<AdvancedCache<?, ?>>(){

                @Override
                public AdvancedCache<?, ?> create(Bean<AdvancedCache<?, ?>> bean, CreationalContext<AdvancedCache<?, ?>> creationalContext) {
                    return ((AdvancedCacheProducer)new ContextualReference(beanManager, (Type)((Object)AdvancedCacheProducer.class), new Annotation[0]).create((CreationalContext)Reflections.cast(creationalContext)).get()).getAdvancedCache(holder.getName(), holder.getQualifiers());
                }

                @Override
                public void destroy(Bean<AdvancedCache<?, ?>> bean, AdvancedCache<?, ?> instance, CreationalContext<AdvancedCache<?, ?>> creationalContext) {
                }
            }).create();
            event.addBean(b);
        }
    }

    <K, V> void registerInputCacheCustomBean(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        TypeLiteral typeLiteral = new TypeLiteral<Cache<K, V>>(){};
        event.addBean(new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(typeLiteral.getRawType())).addType(typeLiteral.getType()).qualifiers(new InputLiteral()).beanLifecycle(new ContextualLifecycle<Cache<K, V>>(){

            @Override
            public Cache<K, V> create(Bean<Cache<K, V>> bean, CreationalContext<Cache<K, V>> creationalContext) {
                return ContextInputCache.get();
            }

            @Override
            public void destroy(Bean<Cache<K, V>> bean, Cache<K, V> instance, CreationalContext<Cache<K, V>> creationalContext) {
            }
        }).create());
    }

    public void observeDefaultEmbeddedCacheManagerInstalled(@Observes @Installed DefaultBeanHolder bean) {
        if (bean.getBean().getTypes().contains(EmbeddedCacheManager.class)) {
            this.installedEmbeddedCacheManagers.add(bean.getBean().getQualifiers());
        }
    }

    public Set<InstalledCacheManager> getInstalledEmbeddedCacheManagers(BeanManager beanManager) {
        HashSet<InstalledCacheManager> installedCacheManagers = new HashSet<InstalledCacheManager>();
        for (Set<Annotation> qualifiers : this.installedEmbeddedCacheManagers) {
            Bean b = beanManager.resolve(beanManager.getBeans(EmbeddedCacheManager.class, qualifiers.toArray(Reflections.EMPTY_ANNOTATION_ARRAY)));
            EmbeddedCacheManager cm = (EmbeddedCacheManager)beanManager.getReference(b, EmbeddedCacheManager.class, beanManager.createCreationalContext((Contextual)b));
            installedCacheManagers.add(new InstalledCacheManager(cm, qualifiers.contains(DefaultLiteral.INSTANCE)));
        }
        return installedCacheManagers;
    }

    public void observeEmbeddedCacheManagerBean(@Observes ProcessBean<?> processBean) {
        if (processBean.getBean().getTypes().contains(EmbeddedCacheManager.class) && !processBean.getAnnotated().isAnnotationPresent(DefaultBean.class)) {
            this.installedEmbeddedCacheManagers.add(processBean.getBean().getQualifiers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheConfigurations(CacheManagerEventBridge eventBridge, Instance<EmbeddedCacheManager> cacheManagers, BeanManager beanManager) {
        if (!this.registered) {
            Object object = this.registerLock;
            synchronized (object) {
                if (!this.registered) {
                    CreationalContext ctx = beanManager.createCreationalContext(null);
                    EmbeddedCacheManager defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{DefaultLiteral.INSTANCE}).get();
                    for (ConfigurationHolder oneConfigurationHolder : this.configurations) {
                        EmbeddedCacheManager cacheManager;
                        String cacheName = oneConfigurationHolder.getName();
                        Configuration cacheConfiguration = (Configuration)oneConfigurationHolder.getProducer().produce(ctx);
                        Set<Annotation> cacheQualifiers = oneConfigurationHolder.getQualifiers();
                        Instance specificCacheManager = cacheManagers.select(cacheQualifiers.toArray(new Annotation[cacheQualifiers.size()]));
                        EmbeddedCacheManager embeddedCacheManager = cacheManager = specificCacheManager.isUnsatisfied() ? defaultCacheManager : (EmbeddedCacheManager)specificCacheManager.get();
                        if (!cacheName.trim().isEmpty()) {
                            if (cacheConfiguration != null) {
                                cacheManager.defineConfiguration(cacheName, cacheConfiguration);
                                logger.cacheConfigurationDefined(cacheName, cacheManager);
                            } else if (!cacheManager.getCacheNames().contains(cacheName)) {
                                cacheManager.defineConfiguration(cacheName, cacheManager.getDefaultCacheConfiguration());
                                logger.cacheConfigurationDefined(cacheName, cacheManager);
                            }
                        }
                        eventBridge.registerObservers(cacheQualifiers, cacheName, cacheManager);
                    }
                    this.registered = true;
                }
            }
        }
    }

    public static class InstalledCacheManager {
        final EmbeddedCacheManager cacheManager;
        final boolean isDefault;

        InstalledCacheManager(EmbeddedCacheManager cacheManager, boolean aDefault) {
            this.cacheManager = cacheManager;
            this.isDefault = aDefault;
        }

        public EmbeddedCacheManager getCacheManager() {
            return this.cacheManager;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }

    static class ConfigurationHolder {
        private final Producer<Configuration> producer;
        private final Set<Annotation> qualifiers;
        private final String name;

        ConfigurationHolder(Producer<Configuration> producer, String name, Set<Annotation> qualifiers) {
            this.producer = producer;
            this.name = name;
            this.qualifiers = qualifiers;
        }

        public Producer<Configuration> getProducer() {
            return this.producer;
        }

        public String getName() {
            return this.name;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

