/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAuthorizationManagerAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheDistributionManagerAction;
import org.infinispan.security.actions.GetCacheInterceptorChainAction;
import org.infinispan.security.actions.GetCacheRpcManagerAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static AuthorizationManager getCacheAuthorizationManager(AdvancedCache<?, ?> cache) {
        GetCacheAuthorizationManagerAction action = new GetCacheAuthorizationManagerAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static RpcManager getCacheRpcManager(AdvancedCache<?, ?> cache) {
        GetCacheRpcManagerAction action = new GetCacheRpcManagerAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static DistributionManager getCacheDistributionManager(AdvancedCache<?, ?> cache) {
        GetCacheDistributionManagerAction action = new GetCacheDistributionManagerAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static List<CommandInterceptor> getInterceptorChain(AdvancedCache<?, ?> cache) {
        GetCacheInterceptorChainAction action = new GetCacheInterceptorChainAction(cache);
        return SecurityActions.doPrivileged(action);
    }
}

