/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.functional.impl.EntryViews;

public final class ReadOnlyManyCommand<K, V, R>
extends AbstractDataCommand
implements LocalCommand {
    private Set<? extends K> keys;
    private Function<EntryView.ReadEntryView<K, V>, R> f;
    private ConsistentHash ch;
    private Map<Object, InternalCacheEntry> remotelyFetched;

    public ReadOnlyManyCommand(Set<? extends K> keys, Function<EntryView.ReadEntryView<K, V>, R> f) {
        this.keys = keys;
        this.f = f;
    }

    public ReadOnlyManyCommand() {
    }

    public Set<? extends K> getKeys() {
        return this.keys;
    }

    @Override
    public byte getCommandId() {
        return -1;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    public ConsistentHash getConsistentHash() {
        return this.ch;
    }

    public void setConsistentHashAndAddress(ConsistentHash ch) {
        this.ch = ch;
    }

    public Map<Object, InternalCacheEntry> getRemotelyFetched() {
        return this.remotelyFetched;
    }

    public void setRemotelyFetched(Map<Object, InternalCacheEntry> remotelyFetched) {
        this.remotelyFetched = remotelyFetched;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        return this.keys.stream().map(k -> {
            CacheEntry<K, V> me = this.lookupCacheEntry(ctx, k);
            R ret = this.f.apply(me == null ? EntryViews.noValue(k) : EntryViews.readOnly(me));
            return EntryViews.snapshot(ret);
        });
    }

    private CacheEntry<K, V> lookupCacheEntry(InvocationContext ctx, Object key) {
        return ctx.lookupEntry(key);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyManyCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public String toString() {
        return "ReadOnlyManyCommand{keys=" + this.keys + ", f=" + this.f + ", ch=" + this.ch + ", remotelyFetched=" + this.remotelyFetched + '}';
    }
}

