/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.InternalCacheEntry;

public class StateChunk {
    private final int segmentId;
    private final Collection<InternalCacheEntry> cacheEntries;
    private final boolean isLastChunk;

    public StateChunk(int segmentId, Collection<InternalCacheEntry> cacheEntries, boolean isLastChunk) {
        this.segmentId = segmentId;
        this.cacheEntries = cacheEntries;
        this.isLastChunk = isLastChunk;
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public Collection<InternalCacheEntry> getCacheEntries() {
        return this.cacheEntries;
    }

    public boolean isLastChunk() {
        return this.isLastChunk;
    }

    public String toString() {
        return "StateChunk{segmentId=" + this.segmentId + ", cacheEntries=" + this.cacheEntries.size() + ", isLastChunk=" + this.isLastChunk + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<StateChunk> {
        @Override
        public Integer getId() {
            return 86;
        }

        @Override
        public Set<Class<? extends StateChunk>> getTypeClasses() {
            return Collections.singleton(StateChunk.class);
        }

        @Override
        public void writeObject(ObjectOutput output, StateChunk object) throws IOException {
            output.writeInt(object.segmentId);
            output.writeObject(object.cacheEntries);
            output.writeBoolean(object.isLastChunk);
        }

        @Override
        public StateChunk readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int segmentId = input.readInt();
            Collection cacheEntries = (Collection)input.readObject();
            boolean isLastChunk = input.readBoolean();
            return new StateChunk(segmentId, cacheEntries, isLastChunk);
        }
    }
}

