/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.infinispan.remoting.responses.Response;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;

class SingleResponseFuture
extends CompletableFuture<Rsp<Response>>
implements FutureListener<Response>,
Callable<Void> {
    private final UnicastRequest request;
    private volatile Future<?> timeoutFuture = null;

    SingleResponseFuture(NotifyingFuture<Response> request) {
        this.request = (UnicastRequest)request;
        request.setListener(this);
    }

    @Override
    public void futureDone(Future<Response> future) {
        Rsp response = this.request.getResult();
        this.complete(response);
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    public void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
        if (this.isDone()) {
            timeoutFuture.cancel(false);
        }
    }

    @Override
    public Void call() throws Exception {
        this.complete(this.request.getResult());
        this.request.cancel(false);
        return null;
    }
}

