/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.remoting.inboundhandler.action.BaseLockingAction;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockPromise;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;

public class LockAction
extends BaseLockingAction
implements LockListener {
    private final LockManager lockManager;
    private final CompletableFuture<Void> notifier;
    private volatile LockPromise lockPromise;

    public LockAction(LockManager lockManager, ClusteringDependentLogic clusteringDependentLogic) {
        super(clusteringDependentLogic);
        this.lockManager = lockManager;
        this.notifier = new CompletableFuture();
    }

    @Override
    protected ActionStatus checking(ActionState ignored) {
        LockPromise promise = this.lockPromise;
        if (promise != null && promise.isAvailable()) {
            this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY);
            return ActionStatus.READY;
        }
        return ActionStatus.NOT_READY;
    }

    @Override
    protected ActionStatus init(ActionState state) {
        if (!this.cas(BaseLockingAction.InternalState.INIT, BaseLockingAction.InternalState.CHECKING)) {
            return ActionStatus.NOT_READY;
        }
        Object lockOwner = this.getLockOwner(state);
        long timeout = state.getTimeout();
        List<Object> keysToLock = this.getAndUpdateFilteredKeys(state);
        if (keysToLock.isEmpty()) {
            return this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY) ? ActionStatus.READY : ActionStatus.NOT_READY;
        }
        KeyAwareLockPromise promise = keysToLock.size() == 1 ? this.lockManager.lock(keysToLock.get(0), lockOwner, timeout, TimeUnit.MILLISECONDS) : this.lockManager.lockAll(keysToLock, lockOwner, timeout, TimeUnit.MILLISECONDS);
        this.lockPromise = promise;
        if (!promise.isAvailable()) {
            promise.addListener(this);
        }
        return this.check(state);
    }

    private Object getLockOwner(ActionState state) {
        RemoteLockCommand command = state.getCommand();
        return command instanceof TransactionalRemoteLockCommand ? ((TransactionalRemoteLockCommand)command).createContext().getLockOwner() : command.getLockOwner();
    }

    @Override
    public void addListener(ActionListener listener) {
        this.notifier.thenRun(listener::onComplete);
    }

    @Override
    public void onEvent(LockState state) {
        this.notifier.complete(null);
    }
}

