/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryVersion;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public final class MetaParamExternalizers {
    private MetaParamExternalizers() {
    }

    public static final class NumericEntryVersionExternalizer
    extends AbstractExternalizer<EntryVersion.NumericEntryVersion> {
        @Override
        public void writeObject(ObjectOutput output, EntryVersion.NumericEntryVersion object) throws IOException {
            output.writeLong(object.get());
        }

        @Override
        public EntryVersion.NumericEntryVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long version = input.readLong();
            return new EntryVersion.NumericEntryVersion(version);
        }

        @Override
        public Set<Class<? extends EntryVersion.NumericEntryVersion>> getTypeClasses() {
            return Util.asSet(EntryVersion.NumericEntryVersion.class);
        }

        @Override
        public Integer getId() {
            return 156;
        }
    }

    public static final class EntryVersionParamExternalizer
    extends AbstractExternalizer<MetaParam.EntryVersionParam> {
        @Override
        public void writeObject(ObjectOutput output, MetaParam.EntryVersionParam object) throws IOException {
            output.writeObject(object.get());
        }

        @Override
        public MetaParam.EntryVersionParam readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            EntryVersion entryVersion = (EntryVersion)input.readObject();
            return new MetaParam.EntryVersionParam(entryVersion);
        }

        @Override
        public Set<Class<? extends MetaParam.EntryVersionParam>> getTypeClasses() {
            return Util.asSet(MetaParam.EntryVersionParam.class);
        }

        @Override
        public Integer getId() {
            return 155;
        }
    }

    public static final class LifespanExternalizer
    extends AbstractExternalizer<MetaParam.Lifespan> {
        @Override
        public void writeObject(ObjectOutput output, MetaParam.Lifespan object) throws IOException {
            output.writeLong(object.get());
        }

        @Override
        public MetaParam.Lifespan readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MetaParam.Lifespan(input.readLong());
        }

        @Override
        public Set<Class<? extends MetaParam.Lifespan>> getTypeClasses() {
            return Util.asSet(MetaParam.Lifespan.class);
        }

        @Override
        public Integer getId() {
            return 154;
        }
    }
}

