/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Traversable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.functional.impl.Iterators;
import org.infinispan.functional.impl.Traversables;

public final class WaitModes {
    static <T> CompletableFuture<T> withWaitFuture(Param<Param.WaitMode> waitParam, ExecutorService asyncExec, Supplier<T> s) {
        switch (waitParam.get()) {
            case BLOCKING: {
                return CompletableFuture.completedFuture(s.get());
            }
            case NON_BLOCKING: {
                return CompletableFuture.supplyAsync(s, asyncExec);
            }
        }
        throw new IllegalStateException();
    }

    static <T> Traversable<T> withWaitTraversable(Param<Param.WaitMode> waitParam, Supplier<Stream<T>> s) {
        switch (waitParam.get()) {
            case BLOCKING: {
                return Traversables.eager(s.get());
            }
            case NON_BLOCKING: {
                return Traversables.of(s.get());
            }
        }
        throw new IllegalStateException("Not a valid option");
    }

    static <T> CloseableIterator<T> withWaitIterator(Param<Param.WaitMode> waitParam, Supplier<Stream<T>> s) {
        switch (waitParam.get()) {
            case BLOCKING: {
                return Iterators.eager(s.get());
            }
            case NON_BLOCKING: {
                return Iterators.of(s.get());
            }
        }
        throw new IllegalStateException("Not yet implemented");
    }

    private WaitModes() {
    }
}

