/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

@NotThreadSafe
public final class MetaParams {
    private MetaParam<?>[] metas;

    private MetaParams(MetaParam<?>[] metas) {
        this.metas = metas;
    }

    public boolean isEmpty() {
        return this.metas.length == 0;
    }

    public int size() {
        return this.metas.length;
    }

    public <T> Optional<T> find(Class<T> type) {
        return Optional.ofNullable(this.findNullable(type));
    }

    public <T> T get(Class<T> type) throws NoSuchElementException {
        T param = this.findNullable(type);
        if (param == null) {
            throw new NoSuchElementException("Metadata with type=" + type + " not found");
        }
        return param;
    }

    private <T> T findNullable(Class<T> type) {
        for (MetaParam<?> meta : this.metas) {
            if (!meta.getClass().isAssignableFrom(type)) continue;
            return (T)meta;
        }
        return null;
    }

    public void add(MetaParam.Writable meta) {
        if (this.metas.length == 0) {
            this.metas = new MetaParam[]{meta};
        } else {
            boolean found = false;
            for (int i = 0; i < this.metas.length; ++i) {
                if (!this.metas[i].getClass().isAssignableFrom(meta.getClass())) continue;
                this.metas[i] = meta;
                found = true;
            }
            if (!found) {
                MetaParam<?>[] newMetas = Arrays.copyOf(this.metas, this.metas.length + 1);
                newMetas[newMetas.length - 1] = meta;
                this.metas = newMetas;
            }
        }
    }

    public void addMany(MetaParam.Writable ... metaParams) {
        if (this.metas.length == 0) {
            this.metas = metaParams;
        } else {
            ArrayList<MetaParam.Writable> notFound = new ArrayList<MetaParam.Writable>(metaParams.length);
            for (MetaParam.Writable newMeta : metaParams) {
                boolean found = false;
                for (int i = 0; i < this.metas.length; ++i) {
                    if (!this.metas[i].getClass().isAssignableFrom(newMeta.getClass())) continue;
                    this.metas[i] = newMeta;
                    found = true;
                }
                if (found) continue;
                notFound.add(newMeta);
            }
            if (!notFound.isEmpty()) {
                ArrayList allMetasList = new ArrayList(Arrays.asList(this.metas));
                allMetasList.addAll(notFound);
                this.metas = allMetasList.toArray(new MetaParam[this.metas.length + notFound.size()]);
            }
        }
    }

    static MetaParams of(MetaParam ... metas) {
        return new MetaParams(metas);
    }

    static MetaParams of(MetaParam meta) {
        return new MetaParams(new MetaParam[]{meta});
    }

    static MetaParams empty() {
        return new MetaParams(new MetaParam[0]);
    }

    public static final class Externalizer
    extends AbstractExternalizer<MetaParams> {
        @Override
        public void writeObject(ObjectOutput oo, MetaParams o) throws IOException {
            oo.writeInt(o.metas.length);
            for (MetaParam meta : o.metas) {
                oo.writeObject(meta);
            }
        }

        @Override
        public MetaParams readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int length = input.readInt();
            MetaParam[] metas = new MetaParam[length];
            for (int i = 0; i < length; ++i) {
                metas[i] = (MetaParam)input.readObject();
            }
            return MetaParams.of(metas);
        }

        @Override
        public Set<Class<? extends MetaParams>> getTypeClasses() {
            return Util.asSet(MetaParams.class);
        }

        @Override
        public Integer getId() {
            return 153;
        }
    }
}

