/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.metadata.Metadata;

public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(CacheEntry<K, V> entry) {
        return new CacheEntryReadEntryView(entry);
    }

    public static <K, V> EntryView.WriteEntryView<V> writeOnly(CacheEntry<K, V> entry, FunctionalNotifier<K, V> notifier) {
        return new CacheEntryWriteEntryView(entry, notifier);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> readWrite(CacheEntry<K, V> entry, FunctionalNotifier<K, V> notifier) {
        return new CacheEntryReadWriteEntryView(entry, notifier);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> noValue(K key) {
        return new NoValueView(key);
    }

    private static <K, V> EntryView.ReadEntryView<K, V> readOnly(K key, V value, MetaParams metas) {
        return new ReadViewImpl(key, value, metas);
    }

    private static <K, V> MetaParams updateMetaParams(CacheEntry<K, V> entry, MetaParam.Writable[] metas) {
        if (metas.length != 0) {
            MetaParams metaParams = MetaParams.empty();
            metaParams.addMany(metas);
            entry.setMetadata(MetaParamsInternalMetadata.from(metaParams));
            return metaParams;
        }
        return MetaParams.empty();
    }

    private static <K, V> MetaParams extractMetaParams(CacheEntry<K, V> entry) {
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MetaParamsInternalMetadata) {
            MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
            return metaParamsMetadata.params;
        }
        return MetaParams.empty();
    }

    public static final class NoValueView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;

        public NoValueView(K key) {
            this.key = key;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            throw new NoSuchElementException("No value");
        }

        @Override
        public Optional<V> find() {
            return Optional.empty();
        }

        @Override
        public <T> T getMetaParam(Class<T> type) throws NoSuchElementException {
            throw new NoSuchElementException("No metadata available for type=" + type);
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            return Optional.empty();
        }
    }

    public static final class ReadWriteViewImplExternalizer
    extends AbstractExternalizer<CacheEntryReadWriteEntryView> {
        @Override
        public void writeObject(ObjectOutput output, CacheEntryReadWriteEntryView object) throws IOException {
            output.writeObject(object.entry);
        }

        @Override
        public CacheEntryReadWriteEntryView<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            CacheEntry entry = (CacheEntry)input.readObject();
            return new CacheEntryReadWriteEntryView(entry, null);
        }

        @Override
        public Set<Class<? extends CacheEntryReadWriteEntryView>> getTypeClasses() {
            return Util.asSet(CacheEntryReadWriteEntryView.class);
        }

        @Override
        public Integer getId() {
            return 157;
        }
    }

    private static final class CacheEntryReadWriteEntryView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final FunctionalNotifier<K, V> notifier;
        final CacheEntry<K, V> entry;

        private CacheEntryReadWriteEntryView(CacheEntry<K, V> entry, FunctionalNotifier<K, V> notifier) {
            this.entry = entry;
            this.notifier = notifier;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            boolean hasModified = this.notifier.hasModifyListeners();
            boolean hasCreated = this.notifier.hasCreateListeners();
            if (hasModified && !this.entry.isCreated()) {
                this.setAndNotifyModified(value, metas);
            } else if (hasCreated && this.entry.isCreated()) {
                this.setAndNotifyCreated(value, metas);
            } else {
                this.setOnly(value, metas);
            }
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        private void setAndNotifyModified(V value, MetaParam.Writable[] metas) {
            K key = this.entry.getKey();
            V prev = this.entry.getValue();
            MetaParams prevMetas = EntryViews.extractMetaParams(this.entry);
            this.entry.setValue(value);
            this.entry.setChanged(true);
            MetaParams newMetas = EntryViews.updateMetaParams(this.entry, metas);
            this.notifier.notifyOnModify(EntryViews.readOnly(key, prev, prevMetas), EntryViews.readOnly(key, value, newMetas));
        }

        private void setAndNotifyCreated(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            MetaParams newMetas = EntryViews.updateMetaParams(this.entry, metas);
            this.notifier.notifyOnCreate(EntryViews.readOnly(this.entry.getKey(), value, newMetas));
        }

        @Override
        public Void remove() {
            if (!this.entry.isNull()) {
                if (this.notifier.hasRemoveListeners()) {
                    V prev = this.entry.getValue();
                    MetaParams prevMetas = EntryViews.extractMetaParams(this.entry);
                    this.notifier.notifyOnRemove(EntryViews.readOnly(this.entry.getKey(), prev, prevMetas));
                }
                this.entry.setRemoved(true);
                this.entry.setChanged(true);
            }
            return null;
        }

        @Override
        public <T> T getMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.getMetaParam(type);
            }
            throw new NoSuchElementException("Metadata with type=" + type + " not found");
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }
    }

    private static final class CacheEntryWriteEntryView<K, V>
    implements EntryView.WriteEntryView<V> {
        final FunctionalNotifier<K, V> notifier;
        final CacheEntry<K, V> entry;

        private CacheEntryWriteEntryView(CacheEntry<K, V> entry, FunctionalNotifier<K, V> notifier) {
            this.entry = entry;
            this.notifier = notifier;
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
            this.notifier.notifyOnWrite(() -> EntryViews.readOnly(this.entry));
            return null;
        }

        @Override
        public Void remove() {
            this.entry.setRemoved(true);
            this.entry.setChanged(true);
            this.notifier.notifyOnWrite(() -> EntryViews.noValue(this.entry.getKey()));
            return null;
        }
    }

    private static final class ReadViewImpl<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;
        final V value;
        final MetaParams metas;

        private ReadViewImpl(K key, V value, MetaParams metas) {
            this.key = key;
            this.value = value;
            this.metas = metas;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return this.value == null ? Optional.empty() : Optional.ofNullable(this.value);
        }

        @Override
        public <T> T getMetaParam(Class<T> type) throws NoSuchElementException {
            return this.metas.get(type);
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            return this.metas.find(type);
        }
    }

    private static final class CacheEntryReadEntryView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final CacheEntry<K, V> entry;

        private CacheEntryReadEntryView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }

        @Override
        public <T> T getMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.getMetaParam(type);
            }
            throw new NoSuchElementException("Metadata with type=" + type + " not found");
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }
    }
}

