/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PrepareCommand
extends AbstractTransactionBoundaryCommand
implements TransactionalRemoteLockCommand {
    private static final Log log = LogFactory.getLog(PrepareCommand.class);
    private boolean trace = log.isTraceEnabled();
    public static final byte COMMAND_ID = 12;
    protected WriteCommand[] modifications;
    protected boolean onePhaseCommit;
    protected CacheNotifier notifier;
    protected RecoveryManager recoveryManager;
    private transient boolean replayEntryWrapping = false;
    private static final WriteCommand[] EMPTY_WRITE_COMMAND_ARRAY = new WriteCommand[0];

    public void initialize(CacheNotifier notifier, RecoveryManager recoveryManager) {
        this.notifier = notifier;
        this.recoveryManager = recoveryManager;
    }

    private PrepareCommand() {
        super(null);
    }

    public PrepareCommand(String cacheName, GlobalTransaction gtx, boolean onePhaseCommit, WriteCommand ... modifications) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = modifications;
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(String cacheName, GlobalTransaction gtx, List<WriteCommand> commands, boolean onePhaseCommit) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = commands == null || commands.isEmpty() ? null : commands.toArray(new WriteCommand[commands.size()]);
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        RemoteTxInvocationContext ctx = this.createContext();
        if (ctx == null) {
            return null;
        }
        if (this.trace) {
            log.tracef("Invoking remotely originated prepare: %s with invocation context: %s", (Object)this, (Object)ctx);
        }
        this.notifier.notifyTransactionRegistered(ctx.getGlobalTransaction(), false);
        return this.invoker.invoke(ctx, this);
    }

    public RemoteTxInvocationContext createContext() {
        if (this.recoveryManager != null && this.recoveryManager.isTransactionPrepared(this.globalTx)) {
            log.tracef("The transaction %s is already prepared. Skipping prepare call.", (Object)this.globalTx);
            return null;
        }
        RemoteTransaction remoteTransaction = this.getRemoteTransaction();
        if (this.hasModifications()) {
            remoteTransaction.setModifications(Arrays.asList(this.modifications));
        }
        return this.icf.createRemoteTxInvocationContext(remoteTransaction, this.getOrigin());
    }

    @Override
    public Collection<Object> getKeysToLock() {
        if (this.modifications == null || this.modifications.length == 0) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(this.modifications.length);
        InfinispanCollections.forEach(this.modifications, writeCommand -> {
            if (writeCommand.hasFlag(Flag.SKIP_LOCKING)) {
                return;
            }
            switch (writeCommand.getCommandId()) {
                case 8: 
                case 10: 
                case 11: {
                    set.add(((DataWriteCommand)writeCommand).getKey());
                    break;
                }
                case 9: {
                    set.addAll(writeCommand.getAffectedKeys());
                    break;
                }
                case 25: {
                    ApplyDeltaCommand command = (ApplyDeltaCommand)writeCommand;
                    Object[] compositeKeys = command.getCompositeKeys();
                    set.addAll(Arrays.asList(compositeKeys));
                    break;
                }
            }
        });
        return set;
    }

    @Override
    public Object getLockOwner() {
        return this.globalTx;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return false;
    }

    @Override
    public boolean hasSkipLocking() {
        return false;
    }

    @Override
    protected RemoteTransaction getRemoteTransaction() {
        return this.txTable.getOrCreateRemoteTransaction(this.globalTx, this.modifications);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand((TxInvocationContext)ctx, this);
    }

    public WriteCommand[] getModifications() {
        return this.modifications == null ? EMPTY_WRITE_COMMAND_ARRAY : this.modifications;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    @Override
    public byte getCommandId() {
        return 12;
    }

    @Override
    public Object[] getParameters() {
        int numMods = this.modifications == null ? 0 : this.modifications.length;
        int i = 0;
        int params = 3;
        Object[] retval = new Object[numMods + 3];
        retval[i++] = this.globalTx;
        retval[i++] = this.onePhaseCommit;
        retval[i] = numMods;
        if (numMods > 0) {
            System.arraycopy(this.modifications, 0, retval, 3, numMods);
        }
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        int numMods;
        int i = 0;
        this.globalTx = (GlobalTransaction)args[i++];
        this.onePhaseCommit = (Boolean)args[i++];
        if ((numMods = ((Integer)args[i++]).intValue()) > 0) {
            this.modifications = new WriteCommand[numMods];
            System.arraycopy(args, i, this.modifications, 0, numMods);
        }
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand(this.cacheName);
        copy.globalTx = this.globalTx;
        copy.modifications = this.modifications == null ? null : (WriteCommand[])this.modifications.clone();
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    @Override
    public String toString() {
        return "PrepareCommand {modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", " + super.toString();
    }

    public boolean hasModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public Set<Object> getAffectedKeys() {
        if (this.modifications == null || this.modifications.length == 0) {
            return InfinispanCollections.emptySet();
        }
        if (this.modifications.length == 1) {
            return this.modifications[0].getAffectedKeys();
        }
        HashSet<Object> keys = new HashSet<Object>(this.modifications.length);
        for (WriteCommand wc : this.modifications) {
            keys.addAll(wc.getAffectedKeys());
        }
        return keys;
    }

    public boolean isReplayEntryWrapping() {
        return this.replayEntryWrapping;
    }

    public void setReplayEntryWrapping(boolean replayEntryWrapping) {
        this.replayEntryWrapping = replayEntryWrapping;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }
}

