/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.lifecycle.ComponentStatus;

public final class WriteOnlyManyEntriesCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 57;
    private Map<? extends K, ? extends V> entries;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyEntriesCommand(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        this.entries = entries;
        this.f = f;
    }

    public WriteOnlyManyEntriesCommand(WriteOnlyManyEntriesCommand<K, V> command) {
        this.entries = command.entries;
        this.f = command.f;
    }

    public WriteOnlyManyEntriesCommand() {
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    @Override
    public byte getCommandId() {
        return 57;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.entries = (Map)parameters[0];
        this.f = (BiConsumer)parameters[1];
        this.isForwarded = (Boolean)parameters[2];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.entries, this.f, this.isForwarded};
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList returns = new ArrayList(this.entries.size());
        for (Map.Entry<K, V> entry : this.entries.entrySet()) {
            CacheEntry cacheEntry = ctx.lookupEntry(entry.getKey());
            if (cacheEntry == null) continue;
            this.f.accept(entry.getValue(), EntryViews.writeOnly(cacheEntry, this.notifier));
            returns.add(null);
        }
        return returns.stream();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyEntriesCommand(ctx, this);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }
}

