/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuditResponse;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.Security;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthorizationHelper {
    private static final Log log = LogFactory.getLog(AuthorizationHelper.class);
    private final GlobalSecurityConfiguration globalConfiguration;
    private final AuditLogger audit;
    private final AuditContext context;
    private final String name;
    private final ClusterRegistry<String, Subject, Integer> maskCache;
    private final String maskCacheScope;

    public AuthorizationHelper(GlobalSecurityConfiguration globalConfiguration, AuditContext context, String name, ClusterRegistry<String, Subject, Integer> clusterRegistry) {
        this.globalConfiguration = globalConfiguration;
        this.audit = globalConfiguration.authorization().auditLogger();
        this.context = context;
        this.name = name;
        this.maskCache = clusterRegistry;
        this.maskCacheScope = AuthorizationManager.class.getSimpleName() + "_" + name;
    }

    public AuthorizationHelper(GlobalSecurityConfiguration globalConfiguration, AuditContext context, String name) {
        this(globalConfiguration, context, name, null);
    }

    public void checkPermission(AuthorizationPermission perm) {
        this.checkPermission(null, perm);
    }

    public void checkPermission(AuthorizationConfiguration configuration, AuthorizationPermission perm) {
        if (this.globalConfiguration.authorization().enabled()) {
            if (Security.isPrivileged()) {
                Security.checkPermission(perm.getSecurityPermission());
            } else {
                Subject subject = Security.getSubject();
                try {
                    if (subject != null) {
                        int subjectMask = this.computeSubjectRoleMask(subject, configuration);
                        if ((subjectMask & perm.getMask()) != perm.getMask()) {
                            this.checkSecurityManagerPermission(perm);
                        } else {
                            this.audit.audit(subject, this.context, this.name, perm, AuditResponse.ALLOW);
                        }
                    } else {
                        this.checkSecurityManagerPermission(perm);
                    }
                }
                catch (SecurityException e) {
                    this.audit.audit(subject, this.context, this.name, perm, AuditResponse.DENY);
                    throw log.unauthorizedAccess(Util.prettyPrintSubject(subject), perm.toString());
                }
            }
        }
    }

    private void checkSecurityManagerPermission(AuthorizationPermission perm) {
        if (System.getSecurityManager() == null) {
            throw new AccessControlException("", perm.getSecurityPermission());
        }
        System.getSecurityManager().checkPermission(perm.getSecurityPermission());
    }

    public int computeSubjectRoleMask(Subject subject, AuthorizationConfiguration configuration) {
        if (subject != null) {
            Integer cachedMask;
            try {
                cachedMask = this.maskCache != null ? this.maskCache.get(this.maskCacheScope, subject) : null;
            }
            catch (IllegalStateException e) {
                cachedMask = null;
            }
            if (cachedMask != null) {
                return cachedMask;
            }
            int mask = 0;
            PrincipalRoleMapper roleMapper = this.globalConfiguration.authorization().principalRoleMapper();
            for (Principal principal : subject.getPrincipals()) {
                Set<String> roleNames = roleMapper.principalToRoles(principal);
                if (roleNames == null) continue;
                for (String roleName : roleNames) {
                    Role role;
                    if (configuration != null && !configuration.roles().contains(roleName) || (role = this.globalConfiguration.authorization().roles().get(roleName)) == null) continue;
                    mask |= role.getMask();
                }
            }
            try {
                if (this.maskCache != null) {
                    this.maskCache.put(this.maskCacheScope, subject, mask, this.globalConfiguration.securityCacheTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            return mask;
        }
        return 0;
    }
}

